/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataCommunication;

import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.humanoidRobotics.communication.packets.manipulation.wholeBodyTrajectory.WholeBodyTrajectoryToolboxMessageTools;
import us.ihmc.robotDataLogger.YoVariableClient;
import us.ihmc.robotDataLogger.YoVariableServer;
import us.ihmc.robotDataLogger.YoVariablesUpdatedListener;
import us.ihmc.robotDataLogger.logger.DataServerSettings;
import us.ihmc.robotDataVisualizer.visualizer.SCSVisualizer;
import us.ihmc.robotics.Assert;
import us.ihmc.yoVariables.buffer.YoBuffer;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoLong;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoVariableConnectionBurstTest {
    private static final double dt = 0.001;
    private long timestamp = 0L;
    private static final DataServerSettings logSettings = new DataServerSettings(true);
    private final YoRegistry registry = new YoRegistry("Main");
    private final YoLong seq_id = new YoLong("seq_id", this.registry);
    private final YoEnum<TestEnum> var3 = new YoEnum("var3", "", this.registry, TestEnum.class, true);

    private void ensureServerClientConnection(YoVariableServer server, long jitteryTimestamp) {
        ThreadTools.sleepSeconds((double)10.0);
        for (int i = 0; i < 6; ++i) {
            server.update(jitteryTimestamp);
        }
        ThreadTools.sleepSeconds((double)10.0);
    }

    private void updateVariables(YoVariableServer server, long jitteryTimestamp) {
        for (int i = 0; i < 6; ++i) {
            server.update(jitteryTimestamp);
        }
        ThreadTools.sleepSeconds((double)5.0);
    }

    @Disabled
    @Test
    public void TestYoVariableConnectionBurst() {
        YoVariableServer server = new YoVariableServer("TestServer", null, logSettings, 0.001);
        server.setMainRegistry(this.registry, null);
        server.start();
        int bufferSize = 256;
        SCSVisualizer scsYoVariablesUpdatedListener = new SCSVisualizer(bufferSize);
        scsYoVariablesUpdatedListener.setVariableUpdateRate(0);
        scsYoVariablesUpdatedListener.setShowOverheadView(false);
        YoVariableClient client = new YoVariableClient((YoVariablesUpdatedListener)scsYoVariablesUpdatedListener);
        client.start("localhost", 8008);
        this.timestamp += Conversions.secondsToNanoseconds((double)0.001);
        long dtFactor = Conversions.secondsToNanoseconds((double)0.001) / 2L;
        long jitteryTimestamp = this.timestamp + (long)((WholeBodyTrajectoryToolboxMessageTools.random.nextDouble() - 0.5) * (double)dtFactor);
        this.ensureServerClientConnection(server, jitteryTimestamp);
        this.seq_id.set(0L);
        TestEnum[] values = new TestEnum[]{TestEnum.A, TestEnum.B, TestEnum.C, TestEnum.D};
        for (int i = 0; i < 16; ++i) {
            this.seq_id.increment();
            this.var3.set((Enum)values[i % 4]);
            this.updateVariables(server, jitteryTimestamp);
            YoBuffer buffer = scsYoVariablesUpdatedListener.getDataBuffer();
            YoLong seq = (YoLong)buffer.findVariable("seq_id");
            double[] filledBuffer = buffer.getEntry((YoVariable)seq).getBuffer();
            int lastIndex = bufferSize - 1;
            while (buffer.getEntry((YoVariable)seq).getBuffer()[lastIndex] == 0.0) {
                --lastIndex;
            }
            for (int j = lastIndex; j > lastIndex - 8; --j) {
                Assert.assertEquals((String)("Buffer at j: " + filledBuffer[j] + " but buffer at j + 1: " + filledBuffer[j + 1]), (Object)filledBuffer[j], (Object)j);
                Assert.assertFalse((filledBuffer[j] == filledBuffer[j - 1] ? 1 : 0) != 0);
            }
            scsYoVariablesUpdatedListener.closeAndDispose();
            server.close();
        }
    }

    static enum TestEnum {
        A,
        B,
        C,
        D;

    }
}

