/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataCommunication;

import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.robotDataLogger.YoVariableClient;
import us.ihmc.robotDataLogger.YoVariableServer;
import us.ihmc.robotDataLogger.YoVariablesUpdatedListener;
import us.ihmc.robotDataLogger.logger.DataServerSettings;
import us.ihmc.robotDataVisualizer.visualizer.SCSVisualizer;
import us.ihmc.robotics.Assert;
import us.ihmc.yoVariables.buffer.YoBuffer;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoLong;

public class YoVariableConnectionBurstTest {
    private final YoRegistry registry = new YoRegistry("tester");
    private final YoLong seq_id = new YoLong("seq_id", this.registry);
    private final YoLong sleep = new YoLong("sleep", this.registry);
    private final YoEnum<TestEnum> var3 = new YoEnum("var3", "", this.registry, TestEnum.class, true);

    public void TestYoVariableConnectionBurst() {
        YoVariableServer server = new YoVariableServer(this.getClass(), null, new DataServerSettings(false), 0.001);
        server.setMainRegistry(this.registry, null);
        server.start();
        int bufferSize = 256;
        SCSVisualizer scsYoVariablesUpdatedListener = new SCSVisualizer(bufferSize, false);
        scsYoVariablesUpdatedListener.setDisplayOneInNPackets(1);
        scsYoVariablesUpdatedListener.setShowOverheadView(false);
        YoVariableClient client = new YoVariableClient((YoVariablesUpdatedListener)scsYoVariablesUpdatedListener);
        client.startWithHostSelector();
        ThreadTools.sleep((long)1000L);
        this.seq_id.set(0L);
        long timestamp = 0L;
        int i = 0;
        TestEnum[] values = new TestEnum[]{TestEnum.A, TestEnum.B, TestEnum.C, TestEnum.D};
        for (int iter = 0; iter < 100; ++iter) {
            this.seq_id.increment();
            if (++i >= values.length) {
                i = 0;
            }
            this.var3.set((Enum)values[i]);
            server.update(++timestamp);
            if (iter < 50) {
                this.sleep.set(5L);
            } else if (iter % 10 != 0) {
                this.sleep.set(5L);
            } else {
                this.sleep.set(0L);
            }
            ThreadTools.sleep((long)this.sleep.getLongValue());
        }
        ThreadTools.sleep((long)1000L);
        int nCheck = 20;
        YoBuffer buffer = scsYoVariablesUpdatedListener.getDataBuffer();
        YoLong seq = (YoLong)buffer.findVariable("seq_id");
        buffer.setLockIndex(true);
        long lastSeq = seq.getLongValue();
        int lastIndex = buffer.getCurrentIndex();
        for (int j = 0; j < 20; ++j) {
            buffer.setCurrentIndex(lastIndex - j);
            Assert.assertEquals((long)seq.getLongValue(), (long)(lastSeq - (long)j));
        }
        scsYoVariablesUpdatedListener.closeAndDispose();
    }

    public static void main(String[] arg) {
        new YoVariableConnectionBurstTest();
    }

    static enum TestEnum {
        A,
        B,
        C,
        D;

    }
}

