/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.publisher.logger.ui;

import gnu.trove.list.array.TByteArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import us.ihmc.commons.MathTools;
import us.ihmc.publisher.logger.ui.CameraBean;
import us.ihmc.robotDataLogger.Host;

public class HostBean {
    public final SimpleStringProperty hostname = new SimpleStringProperty("localhost");
    public final SimpleIntegerProperty port = new SimpleIntegerProperty(8008);
    public final SimpleObjectProperty<CameraHolder> cameras = new SimpleObjectProperty((Object)new CameraHolder(Collections.emptyList()));

    public HostBean() {
    }

    public HostBean(Host host) {
        this.hostname.set(host.getHostnameAsString());
        this.port.set(host.getPort());
        CameraHolder holder = new CameraHolder();
        for (int i = 0; i < host.getCameras().size(); ++i) {
            holder.cameras.add(host.getCameras().get(i));
        }
        this.setCameras(holder);
    }

    public String getHostname() {
        return this.hostname.get();
    }

    public int getPort() {
        return this.port.get();
    }

    public CameraHolder getCameras() {
        return (CameraHolder)this.cameras.get();
    }

    public void setCameras(CameraHolder cameras) {
        this.cameras.set((Object)cameras);
    }

    public void pack(Host host) {
        host.setHostname(this.getHostname());
        host.setPort(this.getPort());
        for (int i = 0; i < this.getCameras().cameras.size(); ++i) {
            byte camera = this.getCameras().cameras.get(i);
            host.getCameras().add(camera);
        }
    }

    public static class CameraHolder {
        private TByteArrayList cameras = new TByteArrayList();

        public CameraHolder(List<CameraBean> cameras) {
            for (CameraBean camera : cameras) {
                this.cameras.add((byte)MathTools.clamp((int)camera.getCamera_id(), (int)0, (int)127));
            }
        }

        private CameraHolder() {
        }

        public String toString() {
            return this.cameras.toString();
        }
    }
}

