/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.logger;

import java.io.FileWriter;
import java.io.IOException;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.commons.thread.RepeatingTaskThread;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.log.LogTools;
import us.ihmc.robotDataLogger.ZEDSDKAnnounce;
import us.ihmc.zed.SL_InitParameters;
import us.ihmc.zed.SL_RuntimeParameters;
import us.ihmc.zed.ZEDTools;
import us.ihmc.zed.global.zed;

public class ZEDSVOLogger {
    private static final boolean TRANSCODE = false;
    private static int nextCameraId = 0;
    private final int cameraID = nextCameraId++;
    private SL_InitParameters initParameters;
    private SL_RuntimeParameters runtimeParameters;
    private final RepeatingTaskThread grabThread = new RepeatingTaskThread(this.getClass().getName() + "GrabThread", this::grab);
    private String svoPrefix;
    private long controllerZeroInSensorFrame;
    private FileWriter timestampWriter;
    private volatile boolean closed;

    public void connect(String svoFile, String datFile, String address, int port, int fps, int bitrate, long sensorTimestamp, long controllerTimestamp) {
        int returnCode;
        this.closed = false;
        try {
            String[] parts = svoFile.split("[/\\\\]");
            this.svoPrefix = parts[parts.length - 1].substring(0, "yyyyMMdd_HHmmss".length());
            this.timestampWriter = (FileWriter)ExceptionTools.handle(() -> new FileWriter(datFile, true), (ExceptionHandler)DefaultExceptionHandler.RUNTIME_EXCEPTION);
        }
        catch (Exception parts) {
            // empty catch block
        }
        this.initParameters = new SL_InitParameters();
        this.initParameters.input_type(2);
        this.initParameters.async_grab_camera_recovery(true);
        this.runtimeParameters = new SL_RuntimeParameters();
        this.runtimeParameters.reference_frame(1);
        this.runtimeParameters.enable_depth(false);
        this.controllerZeroInSensorFrame = sensorTimestamp - controllerTimestamp;
        LogTools.info((String)("Connecting to ZED SDK stream on: " + address + ":" + port));
        if (zed.sl_is_opened((int)this.cameraID)) {
            zed.sl_close_camera((int)this.cameraID);
        }
        if ((returnCode = zed.sl_open_camera((int)this.cameraID, (SL_InitParameters)this.initParameters, (int)0, (String)"", (String)address, (int)port, (String)"", (String)"", (String)"")) != 0) {
            LogTools.error((String)("Could not connect to ZED SDK stream: " + ZEDTools.errorMessage((int)returnCode)));
        }
        if ((returnCode = zed.sl_enable_recording((int)this.cameraID, (String)svoFile, (int)1, (int)bitrate, (int)fps, (boolean)false)) != 0) {
            LogTools.error((String)("Could not enable SVO recording: " + ZEDTools.errorMessage((int)returnCode)));
        }
        if (zed.sl_is_opened((int)this.cameraID)) {
            LogTools.info((String)("Connected to ZED SDK stream on: " + address + ":" + port));
            this.grabThread.startRepeating();
        }
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.grabThread.blockingKill();
            zed.sl_close_camera((int)this.cameraID);
            zed.sl_unload_instance((int)this.cameraID);
            this.initParameters.close();
            this.runtimeParameters.close();
            System.out.println("Closing ZED SDK stream");
            ExceptionTools.handle(this.timestampWriter::close, (ExceptionHandler)DefaultExceptionHandler.PRINT_MESSAGE);
        }
    }

    public void grab() {
        if (!this.closed) {
            int returnCode = zed.sl_grab((int)this.cameraID, (SL_RuntimeParameters)this.runtimeParameters);
            try {
                long sensorTimestamp = zed.sl_get_current_timestamp((int)this.cameraID);
                long controllerTimestamp = sensorTimestamp - this.controllerZeroInSensorFrame;
                this.timestampWriter.write("%d %d %s%n".formatted(controllerTimestamp, sensorTimestamp, this.svoPrefix));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (returnCode != 0) {
                ThreadTools.park((double)5.0);
                LogTools.info((String)"Could not grab image from ZED, trying again in a few seconds...");
            }
        }
    }

    public void synchronize(ZEDSDKAnnounce message) {
        this.controllerZeroInSensorFrame = message.getSensorTimestamp() - message.getControllerTimestamp();
    }

    public boolean isClosed() {
        return this.closed;
    }
}

