/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.logger.converters;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Properties;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import us.ihmc.idl.serializers.extra.PropertiesSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.robotDataLogger.LogProperties;
import us.ihmc.robotDataLogger.LogPropertiesPubSubType;
import us.ihmc.robotDataLogger.logger.LogPropertiesReader;

public class ModelAttacher
extends SimpleFileVisitor<Path> {
    private static final String modelFilename = "model.sdf";
    private static final String modelResourceBundle = "resources.zip";
    private final PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:robotData.log");
    private final LogModels model;

    public ModelAttacher() throws IOException {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Select directory");
        chooser.setFileSelectionMode(1);
        if (chooser.showOpenDialog(null) == 0) {
            File mainDirectory = chooser.getSelectedFile();
            this.model = ModelAttacher.chooseModel(mainDirectory);
            if (this.model != null) {
                System.out.println("Attaching model " + String.valueOf((Object)this.model));
                Files.walkFileTree(mainDirectory.toPath(), this);
            }
        } else {
            this.model = null;
        }
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
        if (this.matcher.matches(file.getFileName())) {
            try {
                File directory = file.getParent().toFile();
                File log = new File(directory, "robotData.log");
                LogPropertiesReader properties = new LogPropertiesReader(log);
                ModelAttacher.addModel(directory, properties, this.model);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        System.err.println(exc.getMessage());
        return FileVisitResult.CONTINUE;
    }

    public static LogModels chooseModel(File mainDirectory) {
        return (LogModels)((Object)JOptionPane.showInputDialog(null, "Please choose a model to attach to " + String.valueOf(mainDirectory), "Model chooser", 3, null, (Object[])LogModels.values(), null));
    }

    public static void addModel(File modelDirectory, LogProperties properties, LogModels model) throws IOException {
        if (properties.getModel().getLoaderAsString().isEmpty()) {
            if (model == null || !model.isValid()) {
                throw new RuntimeException("Cannot load model files");
            }
            System.out.println("Adding model to " + String.valueOf(modelDirectory));
            properties.getModel().setLoader(model.getLoader());
            properties.getModel().setName(model.getModelName());
            for (String directory : model.getResourceDirectories()) {
                properties.getModel().getResourceDirectoriesList().add(directory);
            }
            properties.getModel().setPath(modelFilename);
            properties.getModel().setResourceBundle(modelResourceBundle);
            File modelFile = new File(modelDirectory, modelFilename);
            Files.copy(model.getModel().toPath(), modelFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            File resourceFile = new File(modelDirectory, modelResourceBundle);
            Files.copy(model.getResources().toPath(), resourceFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            File log = new File(modelDirectory, "robotData.log");
            PropertiesSerializer writer = new PropertiesSerializer((TopicDataType)new LogPropertiesPubSubType());
            writer.serialize(log, (Object)properties);
            System.out.println("Attached model to " + String.valueOf(modelDirectory));
        } else {
            System.out.println(String.valueOf(modelDirectory) + " already contains a robot model");
        }
    }

    public static void main(String[] args) throws IOException {
        new ModelAttacher();
    }

    public static enum LogModels {
        ATLAS("RobotModels/Atlas"),
        STEPPR("RobotModels/Steppr"),
        VALKYRIE("RobotModels/Valkyrie");

        private final boolean valid;
        private final String loader;
        private final String modelName;
        private final String[] resourceDirectories;
        private final File model;
        private final File resources;

        private LogModels(String modelDirectory) {
            Properties logModelProperties;
            File dir = new File(modelDirectory);
            try {
                File log = new File(dir, "description.properties");
                FileReader reader = new FileReader(log);
                logModelProperties = new Properties();
                logModelProperties.load(reader);
                reader.close();
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                this.model = null;
                this.resources = null;
                this.loader = null;
                this.modelName = null;
                this.resourceDirectories = null;
                this.valid = false;
                return;
            }
            this.model = new File(dir, ModelAttacher.modelFilename);
            this.resources = new File(dir, ModelAttacher.modelResourceBundle);
            this.loader = logModelProperties.getProperty("loader");
            this.modelName = logModelProperties.getProperty("modelName");
            this.resourceDirectories = logModelProperties.getProperty("resourceDirectories").split(",");
            this.valid = true;
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getLoader() {
            return this.loader;
        }

        public String getModelName() {
            return this.modelName;
        }

        public String[] getResourceDirectories() {
            return this.resourceDirectories;
        }

        public File getModel() {
            return this.model;
        }

        public File getResources() {
            return this.resources;
        }
    }
}

