/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger;

import java.io.IOException;
import us.ihmc.idl.CDR;
import us.ihmc.idl.IDLSequence;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;
import us.ihmc.robotDataLogger.ModelFileDescription;

public class ModelFileDescriptionPubSubType
implements TopicDataType<ModelFileDescription> {
    public static final String name = "us::ihmc::robotDataLogger::ModelFileDescription";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public final String getDefinitionChecksum() {
        return "b5c3a94c5cae255913526c1c0741e43f65320aa046efc90f86f41ebb5311c3d9";
    }

    public final String getDefinitionVersion() {
        return "local";
    }

    public void serialize(ModelFileDescription data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        ModelFileDescriptionPubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, ModelFileDescription data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        ModelFileDescriptionPubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return ModelFileDescriptionPubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (int i0 = 0; i0 < 255; ++i0) {
            current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        }
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(ModelFileDescription data) {
        return ModelFileDescriptionPubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(ModelFileDescription data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getName().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getModelLoaderClass().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (int i0 = 0; i0 < data.getResourceDirectories().size(); ++i0) {
            current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + ((StringBuilder)data.getResourceDirectories().get(i0)).length() + 1;
        }
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        return current_alignment - initial_alignment;
    }

    public static void write(ModelFileDescription data, CDR cdr) {
        cdr.write_type_7(data.getHasModel());
        if (data.getName().length() > 255) {
            throw new RuntimeException("name field exceeds the maximum length: %d > %d".formatted(data.getName().length(), 255));
        }
        cdr.write_type_d(data.getName());
        if (data.getModelLoaderClass().length() > 255) {
            throw new RuntimeException("modelLoaderClass field exceeds the maximum length: %d > %d".formatted(data.getModelLoaderClass().length(), 255));
        }
        cdr.write_type_d(data.getModelLoaderClass());
        if (data.getResourceDirectories().size() > 255) {
            throw new RuntimeException("resourceDirectories field exceeds the maximum length: %d > %d".formatted(data.getResourceDirectories().size(), 255));
        }
        cdr.write_type_e((IDLSequence)data.getResourceDirectories());
        cdr.write_type_2(data.getModelFileSize());
        cdr.write_type_7(data.getHasResourceZip());
        cdr.write_type_2(data.getResourceZipSize());
    }

    public static void read(ModelFileDescription data, CDR cdr) {
        data.setHasModel(cdr.read_type_7());
        cdr.read_type_d(data.getName());
        cdr.read_type_d(data.getModelLoaderClass());
        cdr.read_type_e((IDLSequence)data.getResourceDirectories());
        data.setModelFileSize(cdr.read_type_2());
        data.setHasResourceZip(cdr.read_type_7());
        data.setResourceZipSize(cdr.read_type_2());
    }

    public final void serialize(ModelFileDescription data, InterchangeSerializer ser) {
        ser.write_type_7("hasModel", data.getHasModel());
        ser.write_type_d("name", data.getName());
        ser.write_type_d("modelLoaderClass", data.getModelLoaderClass());
        ser.write_type_e("resourceDirectories", (IDLSequence)data.getResourceDirectories());
        ser.write_type_2("modelFileSize", data.getModelFileSize());
        ser.write_type_7("hasResourceZip", data.getHasResourceZip());
        ser.write_type_2("resourceZipSize", data.getResourceZipSize());
    }

    public final void deserialize(InterchangeSerializer ser, ModelFileDescription data) {
        data.setHasModel(ser.read_type_7("hasModel"));
        ser.read_type_d("name", data.getName());
        ser.read_type_d("modelLoaderClass", data.getModelLoaderClass());
        ser.read_type_e("resourceDirectories", (IDLSequence)data.getResourceDirectories());
        data.setModelFileSize(ser.read_type_2("modelFileSize"));
        data.setHasResourceZip(ser.read_type_7("hasResourceZip"));
        data.setResourceZipSize(ser.read_type_2("resourceZipSize"));
    }

    public static void staticCopy(ModelFileDescription src, ModelFileDescription dest) {
        dest.set(src);
    }

    public ModelFileDescription createData() {
        return new ModelFileDescription();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)ModelFileDescriptionPubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(ModelFileDescription data, CDR cdr) {
        ModelFileDescriptionPubSubType.write(data, cdr);
    }

    public void deserialize(ModelFileDescription data, CDR cdr) {
        ModelFileDescriptionPubSubType.read(data, cdr);
    }

    public void copy(ModelFileDescription src, ModelFileDescription dest) {
        ModelFileDescriptionPubSubType.staticCopy(src, dest);
    }

    public ModelFileDescriptionPubSubType newInstance() {
        return new ModelFileDescriptionPubSubType();
    }
}

