/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.websocket.client;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.CharsetUtil;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.common.SerializedPayload;
import us.ihmc.robotDataLogger.YoVariableClientImplementation;
import us.ihmc.robotDataLogger.dataBuffers.CustomLogDataSubscriberType;
import us.ihmc.robotDataLogger.dataBuffers.RegistryConsumer;
import us.ihmc.robotDataLogger.dataBuffers.RegistryReceiveBuffer;
import us.ihmc.robotDataLogger.websocket.command.DataServerCommand;

public class WebSocketDataServerClientHandler
extends SimpleChannelInboundHandler<Object> {
    private final WebSocketClientHandshaker handshaker;
    private final RegistryConsumer consumer;
    private final YoVariableClientImplementation yoVariableClient;
    private final CustomLogDataSubscriberType type;
    private final SerializedPayload payload;
    private final int timestampPort;
    private ChannelPromise handshakeFuture;
    private boolean sendConfiguration = false;
    private volatile boolean waitingForPong = false;

    public WebSocketDataServerClientHandler(WebSocketClientHandshaker handshaker, YoVariableClientImplementation yoVariableClient, int timestampPort, RegistryConsumer consumer, CustomLogDataSubscriberType type) {
        this.handshaker = handshaker;
        this.yoVariableClient = yoVariableClient;
        this.consumer = consumer;
        this.type = type;
        this.timestampPort = timestampPort;
        this.payload = new SerializedPayload(type.getTypeSize());
    }

    public ChannelFuture handshakeFuture() {
        return this.handshakeFuture;
    }

    public void handlerAdded(ChannelHandlerContext context) {
        this.handshakeFuture = context.newPromise();
    }

    public void channelActive(ChannelHandlerContext context) {
        this.handshaker.handshake(context.channel());
    }

    public void channelRead0(ChannelHandlerContext context, Object message) throws Exception {
        Channel channel = context.channel();
        if (!this.handshaker.isHandshakeComplete()) {
            this.handshaker.finishHandshake(channel, (FullHttpResponse)message);
            this.yoVariableClient.connected();
            this.handshakeFuture.setSuccess();
            return;
        }
        if (message instanceof FullHttpResponse) {
            FullHttpResponse response = (FullHttpResponse)message;
            throw new IllegalStateException("Unexpected FullHttpResponse (getStatus=" + String.valueOf(response.status()) + ", content=" + response.content().toString(CharsetUtil.UTF_8) + ")");
        }
        WebSocketFrame frame = (WebSocketFrame)message;
        if (frame instanceof TextWebSocketFrame) {
            int argument;
            DataServerCommand command = DataServerCommand.getCommand(frame.content());
            if (command != null && (argument = command.getArgument(frame.content())) != -1) {
                this.yoVariableClient.receivedCommand(command, argument);
            }
        } else if (frame instanceof BinaryWebSocketFrame) {
            RegistryReceiveBuffer buffer = new RegistryReceiveBuffer(System.nanoTime());
            this.payload.getData().clear();
            this.payload.getData().limit(frame.content().readableBytes());
            frame.content().readBytes(this.payload.getData());
            this.payload.getData().flip();
            this.type.deserialize(this.payload, buffer);
            this.consumer.onNewDataMessage(buffer);
            if (!this.sendConfiguration) {
                ByteBuf sendTimestampCmd = context.alloc().buffer(DataServerCommand.MaxCommandSize());
                DataServerCommand.SEND_TIMESTAMPS.getBytes(sendTimestampCmd, this.timestampPort);
                TextWebSocketFrame sendTimestampFrame = new TextWebSocketFrame(sendTimestampCmd);
                channel.writeAndFlush((Object)sendTimestampFrame);
                this.sendConfiguration = true;
            }
        } else if (frame instanceof PongWebSocketFrame) {
            this.waitingForPong = false;
        } else if (frame instanceof CloseWebSocketFrame) {
            LogTools.info((String)"Connection closed by server");
            channel.close();
        }
    }

    public void userEventTriggered(ChannelHandlerContext context, Object event) {
        IdleState idleState;
        if (event instanceof IdleStateEvent && (idleState = ((IdleStateEvent)event).state()) == IdleState.READER_IDLE) {
            if (this.waitingForPong) {
                LogTools.warn((String)"Timeout receiving pong. Closing connection.");
                context.close();
            } else {
                this.waitingForPong = true;
                context.channel().writeAndFlush((Object)new PingWebSocketFrame());
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
        LogTools.warn((String)("Connection closed: " + cause.getMessage()));
        if (!this.handshakeFuture.isDone()) {
            this.handshakeFuture.setFailure(cause);
        }
        context.close();
    }
}

