/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.logger;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.OpenCVFrameGrabber;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.javadecklink.CaptureHandler;
import us.ihmc.log.LogTools;
import us.ihmc.robotDataLogger.LogProperties;
import us.ihmc.robotDataLogger.logger.MagewellMuxer;
import us.ihmc.robotDataLogger.logger.VideoDataLoggerInterface;
import us.ihmc.robotDataLogger.logger.YoVariableLoggerOptions;
import us.ihmc.tools.CaptureTimeTools;

public class MagewellVideoDataLogger
extends VideoDataLoggerInterface
implements CaptureHandler {
    private final YoVariableLoggerOptions options;
    private OpenCVFrameGrabber grabber;
    private FileWriter timestampWriter;
    private MagewellMuxer magewellMuxer;
    private int framesReceivedFromCameraCounter;
    private int timeStampFromControllerCounter;
    private final int deviceNumber;
    private volatile long latestTimeStampFromController = 0L;

    public MagewellVideoDataLogger(String name, String captureType, File logPath, LogProperties logProperties, int deviceNumber, YoVariableLoggerOptions options) throws IOException {
        super(logPath, captureType, logProperties, name);
        this.deviceNumber = deviceNumber;
        this.options = options;
        this.createCaptureInterface();
    }

    private void createCaptureInterface() {
        File timestampFile = new File(this.timestampData);
        File videoCaptureFile = new File(this.videoFile);
        int captureWidth = 1280;
        int captureHeight = 720;
        switch (this.options.getVideoCodec()) {
            case AV_CODEC_ID_H264: 
            case AV_CODEC_ID_MJPEG: {
                this.grabber = new OpenCVFrameGrabber(this.deviceNumber);
                this.grabber.setImageWidth(captureWidth);
                this.grabber.setImageHeight(captureHeight);
                this.grabber.setFrameRate(60.0);
                this.magewellMuxer = new MagewellMuxer(videoCaptureFile, captureWidth, captureHeight);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        try {
            this.timestampWriter = new FileWriter(timestampFile);
            ThreadTools.startAThread(() -> {
                try {
                    this.startCapture();
                }
                catch (Exception e) {
                    LogTools.error((String)"Last frame is bad for {} but who cares, shutting down gracefully because of threading", (Object)this.deviceNumber);
                }
            }, (String)"MagewellCapture");
        }
        catch (IOException e) {
            this.magewellMuxer = null;
            if (this.timestampWriter != null) {
                try {
                    this.timestampWriter.close();
                    timestampFile.delete();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.timestampWriter = null;
            LogTools.info((String)"Cannot start capture interface, timestamp file might already exist");
            e.printStackTrace();
        }
    }

    public void startCapture() throws Exception {
        Frame capturedFrame;
        this.grabber.start();
        this.magewellMuxer.start();
        this.timestampWriter.write("1\n");
        this.timestampWriter.write("60\n");
        long startTime = System.currentTimeMillis();
        while (!this.magewellMuxer.isClosed() && (capturedFrame = this.grabber.grabAtFrameRate()) != null) {
            long videoTimestamp = CaptureTimeTools.timeSinceStartedCaptureInSeconds(System.currentTimeMillis(), startTime);
            this.magewellMuxer.recordFrame(capturedFrame, videoTimestamp);
            this.receivedFrameAtTime(System.nanoTime(), this.magewellMuxer.getTimeStamp(), 1L, 60000L);
        }
        ThreadTools.join();
    }

    @Override
    public void restart() throws IOException {
        this.close();
        this.removeLogFiles();
        this.createCaptureInterface();
    }

    @Override
    public void timestampChanged(long latestTimeStampFromController) {
        if (this.magewellMuxer != null) {
            this.latestTimeStampFromController = latestTimeStampFromController;
            if (this.timeStampFromControllerCounter == 10000) {
                this.timeStampFromControllerCounter = 0;
                LogTools.warn((String)"For Device: {} From Controller (latestTimeStampFromController)={}", (Object)this.deviceNumber, (Object)this.latestTimeStampFromController);
            }
            ++this.timeStampFromControllerCounter;
        }
    }

    @Override
    public void close() {
        LogTools.info((String)"Attempting to Stop video...");
        if (this.magewellMuxer != null) {
            try {
                LogTools.info((String)"Stopping capture for {}, closing output stream of recorder, closing timestamp file... (Don't panic)", (Object)this.deviceNumber);
                this.magewellMuxer.close();
                this.grabber.stop();
                this.timestampWriter.close();
                System.out.println("Whew we did it! Done");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.magewellMuxer = null;
            this.timestampWriter = null;
        }
    }

    public void receivedFrameAtTime(long hardwareTime, long recorderTimeStamp, long timeScaleNumerator, long timeScaleDenumerator) {
        ++this.framesReceivedFromCameraCounter;
        if (this.framesReceivedFromCameraCounter % 600 == 0) {
            LogTools.info((String)"----- Saving the current frame at the current controller timestamp -----");
            LogTools.info((String)"Camera Device Number: {}, at Frame: {},", (Object)this.deviceNumber, (Object)this.framesReceivedFromCameraCounter);
            LogTools.info((String)"latestTimeStampFromController={}, recorderTimeStamp={}", (Object)this.latestTimeStampFromController, (Object)recorderTimeStamp);
        }
        try {
            this.timestampWriter.write(this.latestTimeStampFromController + " " + recorderTimeStamp + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public long getLastFrameReceivedTimestamp() {
        return this.magewellMuxer.getTimeStamp();
    }
}

