/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.logger;

import java.io.File;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.FrameGrabber;
import us.ihmc.log.LogTools;

public class MagewellDemuxer {
    private static final String MAGEWELL_DEMUXER = "MageWell Demuxer";
    private final FFmpegFrameGrabber grabber;

    public MagewellDemuxer(File videoFile) {
        try {
            this.grabber = new FFmpegFrameGrabber(videoFile);
            this.grabber.start();
        }
        catch (FrameGrabber.Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return MAGEWELL_DEMUXER;
    }

    public int getImageHeight() {
        return this.grabber.getImageHeight();
    }

    public int getImageWidth() {
        return this.grabber.getImageWidth();
    }

    public long getCurrentPTS() {
        return this.grabber.getTimestamp();
    }

    public void seekToPTS(long videoTimestamp) {
        try {
            this.grabber.setTimestamp(videoTimestamp);
        }
        catch (FFmpegFrameGrabber.Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int getFrameNumber() {
        return this.grabber.getFrameNumber();
    }

    public Frame getNextFrame() {
        try {
            return this.grabber.grabFrame();
        }
        catch (FrameGrabber.Exception e) {
            throw new RuntimeException(e);
        }
    }

    public double getFrameRate() {
        return this.grabber.getVideoFrameRate();
    }

    public void stop() {
        try {
            this.grabber.stop();
        }
        catch (FFmpegFrameGrabber.Exception e) {
            LogTools.error((String)e.getMessage());
        }
    }
}

