/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.jointState;

import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.mecano.multiBodySystem.SixDoFJoint;
import us.ihmc.robotDataLogger.JointType;
import us.ihmc.robotDataLogger.jointState.JointHolder;

public class SiXDoFJointHolder
implements JointHolder {
    private final SixDoFJoint inverseDynamicsJoint;

    public SiXDoFJointHolder(SixDoFJoint joint) {
        this.inverseDynamicsJoint = joint;
    }

    @Override
    public JointType getJointType() {
        return JointType.SiXDoFJoint;
    }

    @Override
    public int getNumberOfStateVariables() {
        return 13;
    }

    @Override
    public void get(double[] buffer, int offset) {
        QuaternionBasics rotation = this.inverseDynamicsJoint.getJointPose().getOrientation();
        Point3DBasics translation = this.inverseDynamicsJoint.getJointPose().getPosition();
        FixedFrameVector3DBasics angularVelocity = this.inverseDynamicsJoint.getJointTwist().getAngularPart();
        FixedFrameVector3DBasics linearVelocity = this.inverseDynamicsJoint.getJointTwist().getLinearPart();
        buffer[offset++] = rotation.getS();
        buffer[offset++] = rotation.getX();
        buffer[offset++] = rotation.getY();
        buffer[offset++] = rotation.getZ();
        buffer[offset++] = translation.getX();
        buffer[offset++] = translation.getY();
        buffer[offset++] = translation.getZ();
        buffer[offset++] = angularVelocity.getX();
        buffer[offset++] = angularVelocity.getY();
        buffer[offset++] = angularVelocity.getZ();
        buffer[offset++] = linearVelocity.getX();
        buffer[offset++] = linearVelocity.getY();
        buffer[offset] = linearVelocity.getZ();
    }

    @Override
    public String getName() {
        return this.inverseDynamicsJoint.getName();
    }
}

