/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.concurrent.Builder;
import us.ihmc.concurrent.ConcurrentRingBuffer;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.multicastLogDataProtocol.modelLoaders.LogModelProvider;
import us.ihmc.robotDataLogger.LogWatcher;
import us.ihmc.robotDataLogger.RobotVisualizer;
import us.ihmc.robotDataLogger.VariableChangedMessage;
import us.ihmc.robotDataLogger.dataBuffers.RegistrySendBufferBuilder;
import us.ihmc.robotDataLogger.handshake.SummaryProvider;
import us.ihmc.robotDataLogger.handshake.YoVariableHandShakeBuilder;
import us.ihmc.robotDataLogger.interfaces.BufferListenerInterface;
import us.ihmc.robotDataLogger.interfaces.DataProducer;
import us.ihmc.robotDataLogger.interfaces.RegistryPublisher;
import us.ihmc.robotDataLogger.listeners.VariableChangedListener;
import us.ihmc.robotDataLogger.logger.DataServerSettings;
import us.ihmc.robotDataLogger.websocket.server.DataServerServerContent;
import us.ihmc.robotDataLogger.websocket.server.WebsocketDataProducer;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicGroupDefinition;
import us.ihmc.util.PeriodicThreadSchedulerFactory;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoVariableServer
implements RobotVisualizer,
VariableChangedListener {
    private static final int CHANGED_BUFFER_CAPACITY = 128;
    private final double dt;
    private final String name;
    private final LogModelProvider logModelProvider;
    private final DataServerSettings dataServerSettings;
    private String rootRegistryName = "main";
    private YoRegistry mainRegistry = null;
    private final ArrayList<RegistrySendBufferBuilder> registeredBuffers = new ArrayList();
    private final ArrayList<RegistryHolder> registryHolders = new ArrayList();
    private boolean started = false;
    private boolean stopped = false;
    private final DataProducer dataProducer;
    private YoVariableHandShakeBuilder handshakeBuilder;
    private volatile long latestTimestamp;
    private final SummaryProvider summaryProvider = new SummaryProvider();
    private final LogWatcher logWatcher = new LogWatcher();
    private BufferListenerInterface bufferListener = null;

    @Deprecated
    public YoVariableServer(Class<?> mainClazz, PeriodicThreadSchedulerFactory schedulerFactory, LogModelProvider logModelProvider, DataServerSettings dataServerSettings, double dt) {
        this(mainClazz, logModelProvider, dataServerSettings, dt);
    }

    @Deprecated
    public YoVariableServer(String mainClazz, PeriodicThreadSchedulerFactory schedulerFactory, LogModelProvider logModelProvider, DataServerSettings dataServerSettings, double dt) {
        this(mainClazz, logModelProvider, dataServerSettings, dt);
    }

    public YoVariableServer(Class<?> mainClazz, LogModelProvider logModelProvider, DataServerSettings dataServerSettings, double dt) {
        this(mainClazz.getSimpleName(), logModelProvider, dataServerSettings, dt);
    }

    public YoVariableServer(String mainClazz, LogModelProvider logModelProvider, DataServerSettings dataServerSettings, double dt) {
        this.dt = dt;
        this.name = mainClazz;
        this.logModelProvider = logModelProvider;
        this.dataServerSettings = dataServerSettings;
        this.dataProducer = new WebsocketDataProducer(this, this.logWatcher, dataServerSettings);
    }

    public void setRootRegistryName(String name) {
        this.rootRegistryName = name;
    }

    public synchronized void addBufferListener(BufferListenerInterface bufferListener) {
        if (this.started) {
            throw new RuntimeException("Server already started");
        }
        this.bufferListener = bufferListener;
    }

    public synchronized void start() {
        RegistrySendBufferBuilder builder;
        int i;
        if (this.started) {
            throw new RuntimeException("Server already started");
        }
        if (this.stopped) {
            throw new RuntimeException("Cannot restart a YoVariable server");
        }
        this.handshakeBuilder = new YoVariableHandShakeBuilder(this.rootRegistryName, this.dt);
        this.handshakeBuilder.setFrames(ReferenceFrame.getWorldFrame());
        this.handshakeBuilder.setSummaryProvider(this.summaryProvider);
        for (i = 0; i < this.registeredBuffers.size(); ++i) {
            builder = this.registeredBuffers.get(i);
            this.handshakeBuilder.addRegistryBuffer(builder);
        }
        try {
            if (this.bufferListener != null) {
                this.bufferListener.allocateBuffers(this.registeredBuffers.size());
            }
            for (i = 0; i < this.registeredBuffers.size(); ++i) {
                builder = this.registeredBuffers.get(i);
                YoRegistry registry = builder.getYoRegistry();
                try {
                    ConcurrentRingBuffer variableChangeData = new ConcurrentRingBuffer((Builder)new VariableChangedMessage.Builder(), 128);
                    RegistryPublisher publisher = this.dataProducer.createRegistryPublisher(builder, this.bufferListener);
                    this.registryHolders.add(new RegistryHolder(registry, publisher, (ConcurrentRingBuffer<VariableChangedMessage>)variableChangeData));
                    publisher.start();
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            DataServerServerContent content = new DataServerServerContent(this.name, this.handshakeBuilder.getHandShake(), this.logModelProvider, this.dataServerSettings);
            if (this.bufferListener != null) {
                this.bufferListener.setContent(content);
                this.bufferListener.start();
            }
            this.dataProducer.setDataServerContent(content);
            this.dataProducer.announce();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.started = true;
    }

    public RegistryHolder getRegistryHolder(YoRegistry registry) {
        for (int i = 0; i < this.registryHolders.size(); ++i) {
            RegistryHolder registryHolder = this.registryHolders.get(i);
            if (registryHolder.registry != registry) continue;
            return registryHolder;
        }
        throw new RuntimeException("Registry " + registry.getName() + " not registered with addRegistry() or setMainRegistry()");
    }

    @Override
    public synchronized void close() {
        if (this.started && !this.stopped) {
            this.started = false;
            this.stopped = true;
            for (int i = 0; i < this.registryHolders.size(); ++i) {
                this.registryHolders.get((int)i).publisher.stop();
            }
            this.dataProducer.remove();
            if (this.bufferListener != null) {
                this.bufferListener.close();
            }
        }
    }

    @Override
    public void update(long timestamp) {
        this.update(timestamp, this.mainRegistry);
    }

    @Override
    public void update(long timestamp, YoRegistry registry) {
        if (!this.started || this.stopped) {
            return;
        }
        if (registry == this.mainRegistry) {
            this.dataProducer.publishTimestamp(timestamp);
            this.latestTimestamp = timestamp;
        }
        RegistryHolder registryHolder = this.getRegistryHolder(registry);
        registryHolder.publisher.update(timestamp);
        this.updateChangedVariables(registryHolder);
        this.logWatcher.update(timestamp);
    }

    private void updateChangedVariables(RegistryHolder rootRegistry) {
        VariableChangedMessage msg;
        ConcurrentRingBuffer<VariableChangedMessage> buffer = rootRegistry.variableChangeData;
        buffer.poll();
        while ((msg = (VariableChangedMessage)buffer.read()) != null) {
            msg.getVariable().setValueFromDouble(msg.getVal());
        }
        buffer.flush();
    }

    @Override
    public void addRegistry(YoRegistry registry, YoGraphicsListRegistry scs1YoGraphics, YoGraphicGroupDefinition scs2YoGraphics) {
        if (this.mainRegistry == null) {
            throw new RuntimeException("Main registry is not set. Set main registry first");
        }
        this.registeredBuffers.add(new RegistrySendBufferBuilder(registry, scs1YoGraphics, scs2YoGraphics));
    }

    @Override
    public void setMainRegistry(YoRegistry registry, List<? extends JointBasics> jointsToPublish, YoGraphicsListRegistry scs1YoGraphics, YoGraphicGroupDefinition scs2YoGraphics) {
        if (this.mainRegistry != null) {
            throw new RuntimeException("Main registry is already set");
        }
        this.registeredBuffers.add(new RegistrySendBufferBuilder(registry, jointsToPublish, scs1YoGraphics, scs2YoGraphics));
        this.mainRegistry = registry;
    }

    private YoVariable findVariableInRegistries(String variableName) {
        for (RegistrySendBufferBuilder buffer : this.registeredBuffers) {
            YoRegistry registry = buffer.getYoRegistry();
            YoVariable ret = registry.findVariable(variableName);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public void createSummary(YoVariable isWalkingVariable) {
        this.createSummary(isWalkingVariable.getFullNameString());
    }

    public void createSummary(String summaryTriggerVariable) {
        if (this.findVariableInRegistries(summaryTriggerVariable) == null) {
            throw new RuntimeException("Variable " + summaryTriggerVariable + " is not registered with the logger");
        }
        this.summaryProvider.setSummarize(true);
        this.summaryProvider.setSummaryTriggerVariable(summaryTriggerVariable);
    }

    public void addSummarizedVariable(String variable) {
        if (this.findVariableInRegistries(variable) == null) {
            throw new RuntimeException("Variable " + variable + " is not registered with the logger");
        }
        this.summaryProvider.addSummarizedVariable(variable);
    }

    public void addSummarizedVariable(YoVariable variable) {
        this.summaryProvider.addSummarizedVariable(variable);
    }

    @Override
    public long getLatestTimestamp() {
        return this.latestTimestamp;
    }

    public boolean isLogging() {
        return this.logWatcher.isLogging();
    }

    @Override
    public void changeVariable(int id, double newValue) {
        VariableChangedMessage message;
        ImmutablePair<YoVariable, YoRegistry> variableAndRootRegistry = this.handshakeBuilder.getVariablesAndRootRegistries().get(id);
        RegistryHolder holder = this.getRegistryHolder((YoRegistry)variableAndRootRegistry.getRight());
        ConcurrentRingBuffer<VariableChangedMessage> buffer = holder.variableChangeData;
        while ((message = (VariableChangedMessage)buffer.next()) == null) {
            ThreadTools.sleep((long)1L);
        }
        if (message != null) {
            message.setVariable((YoVariable)variableAndRootRegistry.getLeft());
            message.setVal(newValue);
            buffer.commit();
        }
    }

    private class RegistryHolder {
        private final YoRegistry registry;
        private final RegistryPublisher publisher;
        private final ConcurrentRingBuffer<VariableChangedMessage> variableChangeData;

        public RegistryHolder(YoRegistry registry, RegistryPublisher publisher, ConcurrentRingBuffer<VariableChangedMessage> variableChangeData) {
            this.registry = registry;
            this.publisher = publisher;
            this.variableChangeData = variableChangeData;
        }
    }
}

