/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger;

import java.io.IOException;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;
import us.ihmc.robotDataLogger.Camera;

public class CameraPubSubType
implements TopicDataType<Camera> {
    public static final String name = "us::ihmc::robotDataLogger::Camera";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public final String getDefinitionChecksum() {
        return "6d7fe7d3d8b07e957ab466dc84e2d5f653d3e2cceab5599496e96b3271adb0ea";
    }

    public final String getDefinitionVersion() {
        return "local";
    }

    public void serialize(Camera data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        CameraPubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, Camera data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        CameraPubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return CameraPubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(Camera data) {
        return CameraPubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(Camera data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getType().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getName().length() + 1;
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getVideoFile().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getTimestampFile().length() + 1;
        return current_alignment - initial_alignment;
    }

    public static void write(Camera data, CDR cdr) {
        if (data.getType().length() > 255) {
            throw new RuntimeException("type field exceeds the maximum length: %d > %d".formatted(data.getType().length(), 255));
        }
        cdr.write_type_d(data.getType());
        if (data.getName().length() > 255) {
            throw new RuntimeException("name field exceeds the maximum length: %d > %d".formatted(data.getName().length(), 255));
        }
        cdr.write_type_d(data.getName());
        cdr.write_type_7(data.getInterlaced());
        if (data.getVideoFile().length() > 255) {
            throw new RuntimeException("videoFile field exceeds the maximum length: %d > %d".formatted(data.getVideoFile().length(), 255));
        }
        cdr.write_type_d(data.getVideoFile());
        if (data.getTimestampFile().length() > 255) {
            throw new RuntimeException("timestampFile field exceeds the maximum length: %d > %d".formatted(data.getTimestampFile().length(), 255));
        }
        cdr.write_type_d(data.getTimestampFile());
    }

    public static void read(Camera data, CDR cdr) {
        cdr.read_type_d(data.getType());
        cdr.read_type_d(data.getName());
        data.setInterlaced(cdr.read_type_7());
        cdr.read_type_d(data.getVideoFile());
        cdr.read_type_d(data.getTimestampFile());
    }

    public final void serialize(Camera data, InterchangeSerializer ser) {
        ser.write_type_d("type", data.getType());
        ser.write_type_d("name", data.getName());
        ser.write_type_7("interlaced", data.getInterlaced());
        ser.write_type_d("videoFile", data.getVideoFile());
        ser.write_type_d("timestampFile", data.getTimestampFile());
    }

    public final void deserialize(InterchangeSerializer ser, Camera data) {
        ser.read_type_d("type", data.getType());
        ser.read_type_d("name", data.getName());
        data.setInterlaced(ser.read_type_7("interlaced"));
        ser.read_type_d("videoFile", data.getVideoFile());
        ser.read_type_d("timestampFile", data.getTimestampFile());
    }

    public static void staticCopy(Camera src, Camera dest) {
        dest.set(src);
    }

    public Camera createData() {
        return new Camera();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)CameraPubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(Camera data, CDR cdr) {
        CameraPubSubType.write(data, cdr);
    }

    public void deserialize(Camera data, CDR cdr) {
        CameraPubSubType.read(data, cdr);
    }

    public void copy(Camera src, Camera dest) {
        CameraPubSubType.staticCopy(src, dest);
    }

    public CameraPubSubType newInstance() {
        return new CameraPubSubType();
    }
}

