/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger;

import java.io.IOException;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;
import us.ihmc.robotDataLogger.CameraConfiguration;
import us.ihmc.robotDataLogger.CameraConfigurationPubSubType;
import us.ihmc.robotDataLogger.CameraSettings;

public class CameraSettingsPubSubType
implements TopicDataType<CameraSettings> {
    public static final String name = "us::ihmc::robotDataLogger::CameraSettings";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public final String getDefinitionChecksum() {
        return "b17cf095dd34f50a65f2d4089c1236c304021dfc99d8f1583fd0bc86cd86a1d7";
    }

    public final String getDefinitionVersion() {
        return "local";
    }

    public void serialize(CameraSettings data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        CameraSettingsPubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, CameraSettings data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        CameraSettingsPubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return CameraSettingsPubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (int i0 = 0; i0 < 128; ++i0) {
            current_alignment += CameraConfigurationPubSubType.getMaxCdrSerializedSize(current_alignment);
        }
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(CameraSettings data) {
        return CameraSettingsPubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(CameraSettings data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (int i0 = 0; i0 < data.getCameras().size(); ++i0) {
            current_alignment += CameraConfigurationPubSubType.getCdrSerializedSize((CameraConfiguration)((Object)data.getCameras().get(i0)), current_alignment);
        }
        return current_alignment - initial_alignment;
    }

    public static void write(CameraSettings data, CDR cdr) {
        if (data.getCameras().size() > 128) {
            throw new RuntimeException("cameras field exceeds the maximum length");
        }
        cdr.write_type_e(data.getCameras());
    }

    public static void read(CameraSettings data, CDR cdr) {
        cdr.read_type_e(data.getCameras());
    }

    public final void serialize(CameraSettings data, InterchangeSerializer ser) {
        ser.write_type_e("cameras", data.getCameras());
    }

    public final void deserialize(InterchangeSerializer ser, CameraSettings data) {
        ser.read_type_e("cameras", data.getCameras());
    }

    public static void staticCopy(CameraSettings src, CameraSettings dest) {
        dest.set(src);
    }

    public CameraSettings createData() {
        return new CameraSettings();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)CameraSettingsPubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(CameraSettings data, CDR cdr) {
        CameraSettingsPubSubType.write(data, cdr);
    }

    public void deserialize(CameraSettings data, CDR cdr) {
        CameraSettingsPubSubType.read(data, cdr);
    }

    public void copy(CameraSettings src, CameraSettings dest) {
        CameraSettingsPubSubType.staticCopy(src, dest);
    }

    public CameraSettingsPubSubType newInstance() {
        return new CameraSettingsPubSubType();
    }
}

