/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.websocket.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;
import io.netty.handler.timeout.IdleStateHandler;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import us.ihmc.pubsub.common.SerializedPayload;
import us.ihmc.robotDataLogger.VariableChangeRequest;
import us.ihmc.robotDataLogger.VariableChangeRequestPubSubType;
import us.ihmc.robotDataLogger.YoVariableClientImplementation;
import us.ihmc.robotDataLogger.dataBuffers.CustomLogDataSubscriberType;
import us.ihmc.robotDataLogger.dataBuffers.RegistryConsumer;
import us.ihmc.robotDataLogger.handshake.IDLYoVariableHandshakeParser;
import us.ihmc.robotDataLogger.listeners.TimestampListener;
import us.ihmc.robotDataLogger.util.DebugRegistry;
import us.ihmc.robotDataLogger.util.NettyUtils;
import us.ihmc.robotDataLogger.websocket.client.UDPTimestampClient;
import us.ihmc.robotDataLogger.websocket.client.WebSocketDataServerClientHandler;
import us.ihmc.robotDataLogger.websocket.client.discovery.HTTPDataServerConnection;
import us.ihmc.robotDataLogger.websocket.client.discovery.HTTPDataServerDescription;
import us.ihmc.robotDataLogger.websocket.command.DataServerCommand;

public class WebsocketDataServerClient {
    private final EventLoopGroup group = NettyUtils.createEventGroundLoop();
    private final RegistryConsumer consumer;
    private final VariableChangeRequestPubSubType variableChangeRequestType = new VariableChangeRequestPubSubType();
    private final SerializedPayload variableChangeRequestPayload = new SerializedPayload(this.variableChangeRequestType.getTypeSize());
    private final Channel ch;
    private final HTTPDataServerConnection.DisconnectPromise disconnectPromise;
    private final UDPTimestampClient udpTimestampClient;

    public WebsocketDataServerClient(HTTPDataServerConnection connection, IDLYoVariableHandshakeParser parser, TimestampListener timestampListener, YoVariableClientImplementation yoVariableClient, final int timeoutInMs, DebugRegistry debugRegistry) throws IOException {
        URI uri;
        this.disconnectPromise = connection.take();
        HTTPDataServerDescription target = connection.getTarget();
        try {
            uri = new URI("ws://" + target.getHost() + ":" + target.getPort() + "/websocket");
        }
        catch (URISyntaxException e2) {
            throw new IOException(e2);
        }
        this.consumer = new RegistryConsumer(parser, yoVariableClient, debugRegistry);
        this.udpTimestampClient = new UDPTimestampClient(timestampListener);
        this.udpTimestampClient.start();
        CustomLogDataSubscriberType type = new CustomLogDataSubscriberType(parser.getNumberOfVariables(), parser.getNumberOfStates());
        final WebSocketDataServerClientHandler handler = new WebSocketDataServerClientHandler(WebSocketClientHandshakerFactory.newHandshaker((URI)uri, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)true, (HttpHeaders)new DefaultHttpHeaders()), yoVariableClient, this.udpTimestampClient.getPort(), this.consumer, type);
        Bootstrap b = new Bootstrap();
        ((Bootstrap)((Bootstrap)b.group(this.group)).channel(NettyUtils.getSocketChannelClass())).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(this){

            protected void initChannel(SocketChannel ch) {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(65536), WebSocketClientCompressionHandler.INSTANCE, new IdleStateHandler((long)timeoutInMs, 0L, 0L, TimeUnit.MILLISECONDS), handler});
            }
        });
        b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)1000);
        try {
            this.ch = b.connect(uri.getHost(), uri.getPort()).syncUninterruptibly().channel();
            this.ch.closeFuture().addListener(e -> this.disconnected());
        }
        catch (Exception e3) {
            this.disconnected();
            throw new IOException(e3);
        }
    }

    private void disconnected() {
        this.udpTimestampClient.stop();
        this.udpTimestampClient.join();
        this.consumer.stopImmediately();
        try {
            this.consumer.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.disconnectPromise.complete();
        this.group.shutdownGracefully();
    }

    public boolean isActive() {
        return this.ch.isActive();
    }

    public void close() {
        this.ch.close();
    }

    public void writeVariableChangeRequest(int identifier, double valueAsDouble) {
        try {
            VariableChangeRequest msg = new VariableChangeRequest();
            msg.setVariableID(identifier);
            msg.setRequestedValue(valueAsDouble);
            this.variableChangeRequestPayload.getData().clear();
            this.variableChangeRequestType.serialize(msg, this.variableChangeRequestPayload);
            ByteBuf data = this.ch.alloc().buffer(this.variableChangeRequestPayload.getLength());
            data.writeBytes(this.variableChangeRequestPayload.getData());
            BinaryWebSocketFrame frame = new BinaryWebSocketFrame(data);
            this.ch.writeAndFlush((Object)frame);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendCommand(DataServerCommand command, int argument) {
        try {
            ByteBuf cmdBuf = this.ch.alloc().buffer(DataServerCommand.MaxCommandSize());
            command.getBytes(cmdBuf, argument);
            TextWebSocketFrame frame = new TextWebSocketFrame(cmdBuf);
            this.ch.writeAndFlush((Object)frame);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setVariableSynchronizer(Object variableSynchronizer) {
        this.consumer.setVariableSynchronizer(variableSynchronizer);
    }
}

