/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.publisher.logger.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.xfer.FileSystemFile;
import net.schmizz.sshj.xfer.InMemoryDestFile;
import net.schmizz.sshj.xfer.InMemorySourceFile;
import net.schmizz.sshj.xfer.LocalDestFile;
import net.schmizz.sshj.xfer.LocalSourceFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.text.StringEscapeUtils;
import us.ihmc.publisher.logger.utils.DeployConsoleInterface;

public class SSHDeploy
extends Thread {
    private final SSHRemote remote;
    private final DeployConsoleInterface console;
    private final String homeDirectory;
    private DeployScript deployScript;
    private final List<DeployFile> files = new ArrayList<DeployFile>();
    private final List<DeployScript> scripts = new ArrayList<DeployScript>();
    private final ArrayList<ImmutablePair<String, String>> variables = new ArrayList();
    private String customErrorMessage = null;
    private boolean isRebooted = false;

    public SSHDeploy(SSHRemote remote, DeployConsoleInterface console) {
        this.remote = remote;
        this.console = console;
        this.homeDirectory = remote.user.equals("root") ? "/root" : "/home/" + remote.user;
        this.addVariable("HOME", this.homeDirectory);
        this.addVariable("USER", remote.user);
    }

    private String expandFilename(String dest) {
        if ((dest = dest.trim()).startsWith("~/")) {
            return this.homeDirectory + "/" + dest.substring(2);
        }
        return dest;
    }

    public void addBinaryFile(String key, String source, String dest, boolean needRootPermissions) {
        DeployFile deployFile = new DeployFile(new File(source), this.expandFilename(dest), needRootPermissions);
        this.files.add(deployFile);
        this.addVariable(key, deployFile.dest);
        this.addVariable(key + "_NAME", deployFile.getName());
    }

    public void addTextFile(String key, String name, URL content, String dest, boolean needRootPermissions) {
        URLDeployScript script = new URLDeployScript(name, content, this.expandFilename(dest), needRootPermissions);
        this.scripts.add(script);
        this.addVariable(key, script.dest);
        this.addVariable(key + "_NAME", script.name);
    }

    public void addTextFile(String key, String name, String content, String dest, boolean needRootPermissions) {
        StringDeployScript script = new StringDeployScript(name, this.expandFilename(dest), content, needRootPermissions);
        this.scripts.add(script);
        this.addVariable(key, script.dest);
        this.addVariable(key + "_NAME", script.name);
    }

    private void println(String line) {
        this.console.println(this.remote.host + ": " + line);
    }

    private void replaceln(String line) {
        this.console.replaceln(this.remote.host + ": " + line);
    }

    public void addVariable(String key, String value) {
        this.variables.add((ImmutablePair<String, String>)new ImmutablePair((Object)key, (Object)value));
    }

    public void deploy(URL deployScript) {
        this.deployScript = new URLDeployScript(null, deployScript, null, false);
        this.start();
    }

    public void deploy(String deployScript) {
        this.deployScript = new StringDeployScript(null, null, deployScript, false);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String download(String file) throws IOException {
        SSHClient ssh = new SSHClient();
        ssh.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
        ssh.setConnectTimeout(1000);
        ssh.connect(this.remote.host);
        try {
            String string;
            ssh.authPassword(this.remote.user, this.remote.password);
            SFTPClient sftp = ssh.newSFTPClient();
            try {
                DownloadFile out = new DownloadFile(this);
                sftp.get(this.expandFilename(file), (LocalDestFile)out);
                string = out.toString();
            }
            catch (Throwable throwable) {
                sftp.close();
                throw throwable;
            }
            sftp.close();
            return string;
        }
        finally {
            ssh.close();
        }
    }

    private String replaceAllVariables(String original) {
        String modified = original;
        for (ImmutablePair<String, String> p : this.variables) {
            modified = modified.replaceAll("\\$\\{" + (String)p.getLeft() + "\\}", Matcher.quoteReplacement((String)p.getRight()));
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCommand(SSHClient ssh, String commandLine, boolean runAsRoot) throws IOException {
        Object trimCommand = commandLine.trim();
        String escapedSudoPassword = StringEscapeUtils.escapeXSI((String)this.remote.sudoPassword);
        if (((String)trimCommand).isEmpty()) {
            return;
        }
        trimCommand = this.replaceAllVariables((String)trimCommand);
        boolean hideCommand = false;
        if (((String)trimCommand).startsWith("@")) {
            trimCommand = ((String)trimCommand).substring(1);
            hideCommand = true;
        } else {
            this.println((String)trimCommand);
        }
        if (((String)trimCommand).startsWith("#")) {
            return;
        }
        Session session = ssh.startSession();
        if (((String)trimCommand).equals("reboot") || ((String)trimCommand).equals("sudo reboot")) {
            this.println("Rebooting target");
            this.isRebooted = true;
            if ("root".equals(this.remote.user)) {
                session.exec("reboot");
            } else {
                session.exec("echo " + escapedSudoPassword + " | sudo -S -p \"\" reboot");
            }
        } else {
            try {
                int c;
                String echoCommand = trimCommand;
                if (runAsRoot && !((String)trimCommand).startsWith("sudo")) {
                    trimCommand = "sudo " + (String)trimCommand;
                }
                if (((String)trimCommand).contains("sudo ")) {
                    trimCommand = ((String)trimCommand).replaceAll("sudo ", "echo " + escapedSudoPassword + " | sudo -p \"\" -S ");
                }
                trimCommand = (String)trimCommand + " 2>&1";
                Session.Command command = session.exec((String)trimCommand);
                InputStream is = command.getInputStream();
                StringBuilder str = new StringBuilder();
                while ((c = is.read()) != -1) {
                    char ch = (char)c;
                    if (Character.isISOControl(ch)) {
                        if (ch == '\n') {
                            this.println(str.toString());
                        } else {
                            this.replaceln(str.toString());
                        }
                        str.setLength(0);
                        continue;
                    }
                    str.append((char)c);
                }
                command.join(5L, TimeUnit.SECONDS);
                if (command.getExitStatus() != 0) {
                    if (hideCommand) {
                        throw new IOException("Last command returned " + command.getExitStatus());
                    }
                    throw new IOException(echoCommand + " returned " + command.getExitStatus());
                }
            }
            finally {
                session.close();
            }
        }
    }

    private String createTempPath() {
        return "/tmp/" + UUID.randomUUID().toString() + ".tmp";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SSHClient ssh = new SSHClient();
        ssh.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
        ssh.setConnectTimeout(1000);
        this.isRebooted = false;
        this.console.open();
        try {
            try {
                for (DeployFile deployFile : this.files) {
                    if (deployFile.valid()) continue;
                    throw new IOException("Cannot find " + deployFile.source.getAbsolutePath());
                }
                if ("root".equals(this.remote.user) && !this.remote.allowRootLogin) {
                    throw new IOException("Cannot login as root. Use normal user account instead");
                }
                this.println("Connecting as " + this.remote.user);
                ssh.connect(this.remote.host);
                ssh.authPassword(this.remote.user, this.remote.password);
                try (SFTPClient sftp = ssh.newSFTPClient();){
                    String tempPath;
                    for (DeployFile file : this.files) {
                        tempPath = this.createTempPath();
                        this.println("Copying " + file.source.getAbsolutePath() + " to " + file.dest);
                        sftp.put((LocalSourceFile)new FileSystemFile(file.source), tempPath);
                        this.runCommand(ssh, "mkdir -p " + FilenameUtils.getFullPathNoEndSeparator((String)file.dest), file.needRootPermissions);
                        this.runCommand(ssh, "mv " + tempPath + " " + file.dest, file.needRootPermissions);
                    }
                    for (DeployScript script : this.scripts) {
                        this.runCommand(ssh, "mkdir -p " + FilenameUtils.getFullPathNoEndSeparator((String)script.dest), script.needsRootPermission);
                        this.println("Copying " + script.name + " to " + script.dest);
                        script.createInputStream();
                        tempPath = this.createTempPath();
                        sftp.put((LocalSourceFile)script, tempPath);
                        this.runCommand(ssh, "mv " + tempPath + " " + script.dest, script.needsRootPermission);
                    }
                }
                if (this.deployScript != null) {
                    this.deployScript.createInputStream();
                    try {
                        List list = IOUtils.readLines((InputStream)this.deployScript.getInputStream(), (Charset)StandardCharsets.UTF_8);
                        for (String line : list) {
                            this.runCommand(ssh, line, false);
                        }
                    }
                    finally {
                        this.deployScript.getInputStream().close();
                    }
                } else {
                    this.println("No deploy script provided");
                }
                if (!this.isRebooted) {
                    this.runCommand(ssh, "sync", false);
                }
            }
            finally {
                ssh.close();
            }
            this.println("Finished deploy");
            this.console.close();
        }
        catch (IOException e) {
            this.console.closeWithError(e, this.customErrorMessage);
        }
    }

    public void setErrorMessage(String msg) {
        this.customErrorMessage = msg;
    }

    public static class SSHRemote {
        public final String host;
        public final String user;
        public final String password;
        public final String sudoPassword;
        public boolean allowRootLogin = false;

        public SSHRemote(String host, String user, String password, String sudoPassword) {
            this.host = host;
            this.user = user;
            this.password = password;
            this.sudoPassword = sudoPassword;
        }

        public void setAllowRootLogin(boolean allowRootLogin) {
            this.allowRootLogin = allowRootLogin;
        }
    }

    private static class DeployFile {
        private final File source;
        private final String dest;
        private final boolean needRootPermissions;

        public DeployFile(File path, String dest, boolean needRootPermissions) {
            this.source = path;
            this.dest = dest;
            this.needRootPermissions = needRootPermissions;
        }

        public boolean valid() {
            return this.source.exists() && this.source.isFile();
        }

        public String getName() {
            if (this.valid()) {
                return this.source.getName().substring(0, this.source.getName().lastIndexOf(46));
            }
            return this.source.getName();
        }
    }

    private class URLDeployScript
    extends DeployScript {
        private final URL source;
        private int size;
        private InputStream outputStream;

        public URLDeployScript(String name, URL source, String dest, boolean needRootPermissions) {
            super(SSHDeploy.this, name, dest, needRootPermissions);
            this.source = source;
        }

        @Override
        public void createInputStream() throws IOException {
            if (this.source == null) {
                throw new IOException("Source for " + this.getName() + " is null");
            }
            String content = IOUtils.toString((URL)this.source, (Charset)StandardCharsets.UTF_8);
            content = SSHDeploy.this.replaceAllVariables(content);
            this.outputStream = IOUtils.toInputStream((String)content, (Charset)StandardCharsets.UTF_8);
        }

        public long getLength() {
            return this.size;
        }

        public InputStream getInputStream() throws IOException {
            return this.outputStream;
        }
    }

    private abstract class DeployScript
    extends InMemorySourceFile {
        private final String name;
        private final String dest;
        private final boolean needsRootPermission;

        public DeployScript(SSHDeploy sSHDeploy, String name, String dest, boolean needsRootPermission) {
            this.name = name;
            this.dest = dest;
            this.needsRootPermission = needsRootPermission;
        }

        public String getName() {
            return this.name;
        }

        public abstract void createInputStream() throws IOException;
    }

    private class StringDeployScript
    extends DeployScript {
        private final String content;
        private InputStream inputStream;

        public StringDeployScript(String name, String dest, String content, boolean needRootPermission) {
            super(SSHDeploy.this, name, dest, needRootPermission);
            this.content = content;
        }

        public long getLength() {
            return this.content.length();
        }

        public InputStream getInputStream() throws IOException {
            return this.inputStream;
        }

        @Override
        public void createInputStream() throws IOException {
            String newContent = SSHDeploy.this.replaceAllVariables(this.content);
            this.inputStream = IOUtils.toInputStream((String)newContent, (Charset)StandardCharsets.UTF_8);
        }
    }

    private class DownloadFile
    extends InMemoryDestFile {
        private final ByteArrayOutputStream stream = new ByteArrayOutputStream();

        private DownloadFile(SSHDeploy sSHDeploy) {
        }

        public String toString() {
            try {
                return this.stream.toString(StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        public OutputStream getOutputStream() throws IOException {
            return this.stream;
        }
    }
}

