/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.publisher.logger.ui;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.sun.javafx.application.PlatformImpl;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.Date;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Stage;
import us.ihmc.publisher.logger.ui.LoggerDeployController;
import us.ihmc.publisher.logger.ui.LoggerDeployScript;
import us.ihmc.publisher.logger.utils.TeeStream;

public class LoggerDeployApplication {
    private static final URL uiDescription = LoggerDeployApplication.class.getResource("LoggerSetup.fxml");
    private String loggerDist;

    public LoggerDeployApplication(String loggerDist) {
        this.loggerDist = loggerDist;
    }

    public static void open(String loggerDistribution, LoggerDeployScript deployScript, Scene scene) {
        try {
            FXMLLoader loader = new FXMLLoader(uiDescription);
            Parent root = (Parent)loader.load();
            LoggerDeployController controller = (LoggerDeployController)loader.getController();
            controller.setLoggerDistribution(loggerDistribution);
            controller.setDeployScript(deployScript);
            Stage stage = new Stage();
            stage.setTitle("Logger deployment");
            stage.initOwner(scene.getWindow());
            stage.initModality(Modality.APPLICATION_MODAL);
            stage.setScene(new Scene(root, 1280.0, 900.0));
            stage.show();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void start(Stage stage) throws IOException {
        this.redirectOutput();
        FXMLLoader loader = new FXMLLoader(uiDescription);
        Parent root = (Parent)loader.load();
        LoggerDeployController controller = (LoggerDeployController)loader.getController();
        controller.setDeployScript(new LoggerDeployScript(this){});
        controller.setLoggerDistribution(this.loggerDist);
        Scene scene = new Scene(root, 1280.0, 900.0);
        stage.setTitle("Logger deployment");
        stage.setScene(scene);
        stage.show();
    }

    private void redirectOutput() throws FileNotFoundException {
        PrintStream log = new PrintStream(new FileOutputStream("logger-deploy.log", true));
        TeeStream stdOutStream = new TeeStream(System.out, log);
        TeeStream stdErrStream = new TeeStream(System.err, log);
        System.setOut(stdOutStream);
        System.setErr(stdErrStream);
        System.out.println("--- " + new Date().toString() + " ---");
    }

    public static void main(String[] args) throws JSAPException {
        SimpleJSAP jsap = new SimpleJSAP(LoggerDeployApplication.class.getSimpleName(), "Logger deploy application", new Parameter[]{new FlaggedOption("loggerDist", (StringParser)JSAP.STRING_PARSER, null, true, 'd', "logger-dist", "Path to deployed distribution")});
        JSAPResult config = jsap.parse(args);
        if (jsap.messagePrinted()) {
            System.out.println(jsap.getUsage());
            System.out.println(jsap.getHelp());
            System.exit(-1);
        }
        final String loggerDist = config.getString("loggerDist");
        PlatformImpl.startup((Runnable)new Runnable(){

            @Override
            public void run() {
                LoggerDeployApplication app = new LoggerDeployApplication(loggerDist);
                try {
                    app.start(new Stage());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

