/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.websocket.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.ResourceLeakDetector;
import java.io.IOException;
import us.ihmc.robotDataLogger.dataBuffers.RegistrySendBufferBuilder;
import us.ihmc.robotDataLogger.interfaces.BufferListenerInterface;
import us.ihmc.robotDataLogger.interfaces.DataProducer;
import us.ihmc.robotDataLogger.interfaces.RegistryPublisher;
import us.ihmc.robotDataLogger.listeners.VariableChangedListener;
import us.ihmc.robotDataLogger.logger.DataServerSettings;
import us.ihmc.robotDataLogger.logger.LogAliveListener;
import us.ihmc.robotDataLogger.util.NettyUtils;
import us.ihmc.robotDataLogger.websocket.server.DataServerServerContent;
import us.ihmc.robotDataLogger.websocket.server.WebsocketDataBroadcaster;
import us.ihmc.robotDataLogger.websocket.server.WebsocketDataServerInitializer;
import us.ihmc.robotDataLogger.websocket.server.WebsocketRegistryPublisher;
import us.ihmc.robotDataLogger.websocket.server.discovery.DataServerLocationBroadcastSender;

public class WebsocketDataProducer
implements DataProducer {
    private final WebsocketDataBroadcaster broadcaster = new WebsocketDataBroadcaster();
    private final VariableChangedListener variableChangedListener;
    private final LogAliveListener logAliveListener;
    private final int port;
    private final Object lock = new Object();
    private Channel channel = null;
    private final EventLoopGroup bossGroup = NettyUtils.createEventGroundLoop(1);
    private final EventLoopGroup workerGroup = NettyUtils.createEventGroundLoop(1);
    private DataServerLocationBroadcastSender broadcastSender;
    private DataServerServerContent dataServerContent = null;
    private int maximumBufferSize = 0;
    private final boolean autoDiscoverable;
    private int nextBufferID = 0;

    public WebsocketDataProducer(VariableChangedListener variableChangedListener, LogAliveListener logAliveListener, DataServerSettings dataServerSettings) {
        this.variableChangedListener = variableChangedListener;
        this.logAliveListener = logAliveListener;
        this.port = dataServerSettings.getPort();
        this.autoDiscoverable = dataServerSettings.isAutoDiscoverable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove() {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.broadcastSender != null) {
                    this.broadcastSender.stop();
                }
                if (this.broadcaster != null) {
                    this.broadcaster.stop();
                }
                if (this.channel != null) {
                    ChannelFuture closeFuture = this.channel.close();
                    closeFuture.sync();
                }
                if (this.bossGroup != null) {
                    this.bossGroup.shutdownGracefully();
                }
                if (this.workerGroup != null) {
                    this.workerGroup.shutdownGracefully();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setDataServerContent(DataServerServerContent dataServerServerContent) {
        this.dataServerContent = dataServerServerContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void announce() throws IOException {
        if (this.dataServerContent == null) {
            throw new RuntimeException("No content provided");
        }
        Object object = this.lock;
        synchronized (object) {
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.DISABLED);
            try {
                int numberOfRegistryBuffers = this.nextBufferID;
                ServerBootstrap serverBootstrap = new ServerBootstrap();
                ((ServerBootstrap)((ServerBootstrap)serverBootstrap.group(this.bossGroup, this.workerGroup).channel(NettyUtils.getServerSocketChannelClass())).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new WebsocketDataServerInitializer(this.dataServerContent, this.broadcaster, this.variableChangedListener, this.logAliveListener, this.maximumBufferSize, numberOfRegistryBuffers));
                this.channel = serverBootstrap.bind(this.port).sync().channel();
                if (this.autoDiscoverable) {
                    this.broadcastSender = new DataServerLocationBroadcastSender(this.port);
                    this.broadcastSender.start();
                } else {
                    this.broadcastSender = null;
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void publishTimestamp(long timestamp) {
        this.broadcaster.publishTimestamp(timestamp);
    }

    @Override
    public RegistryPublisher createRegistryPublisher(RegistrySendBufferBuilder builder, BufferListenerInterface bufferListener) throws IOException {
        WebsocketRegistryPublisher websocketRegistryPublisher = new WebsocketRegistryPublisher(this.workerGroup, builder, this.broadcaster, this.nextBufferID, bufferListener);
        if (websocketRegistryPublisher.getMaximumBufferSize() > this.maximumBufferSize) {
            this.maximumBufferSize = websocketRegistryPublisher.getMaximumBufferSize();
        }
        ++this.nextBufferID;
        return websocketRegistryPublisher;
    }
}

