/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.logger;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.Semaphore;
import org.freedesktop.gstreamer.Buffer;
import org.freedesktop.gstreamer.Element;
import org.freedesktop.gstreamer.Gst;
import org.freedesktop.gstreamer.Pad;
import org.freedesktop.gstreamer.PadProbeInfo;
import org.freedesktop.gstreamer.PadProbeReturn;
import org.freedesktop.gstreamer.PadProbeType;
import org.freedesktop.gstreamer.Pipeline;
import org.freedesktop.gstreamer.event.EOSEvent;
import org.freedesktop.gstreamer.event.Event;
import us.ihmc.commons.Conversions;
import us.ihmc.javadecklink.CaptureHandler;
import us.ihmc.log.LogTools;
import us.ihmc.robotDataLogger.LogProperties;
import us.ihmc.robotDataLogger.logger.VideoDataLoggerInterface;
import us.ihmc.robotDataLogger.logger.YoVariableLoggerOptions;
import us.ihmc.tools.maps.CircularLongMap;

@Deprecated
public class GStreamerVideoDataLogger
extends VideoDataLoggerInterface
implements CaptureHandler {
    private static boolean WRITTEN_TO_TIMESTAMP = false;
    private static long latestHardwareTimestamp;
    private FileWriter timestampWriter;
    private final Semaphore gotEOSPlayBin = new Semaphore(1);
    private final CircularLongMap circularLongMap = new CircularLongMap(10000);
    private Pipeline pipeline;
    private int frameNumber;
    private final int decklinkID;
    private static volatile long lastFrameTimestamp;
    private static int i;

    public GStreamerVideoDataLogger(String name, File logPath, LogProperties logProperties, int decklinkID, YoVariableLoggerOptions options) throws IOException {
        super(logPath, null, logProperties, name);
        this.decklinkID = decklinkID;
        this.createCaptureInterface();
    }

    private void createCaptureInterface() throws IOException {
        File timestampFile = new File(this.timestampData);
        File videoCaptureFile = new File(this.videoFile);
        this.timestampWriter = new FileWriter(timestampFile);
        this.startCapture(videoCaptureFile);
    }

    public void startCapture(File videoCaptureFie) {
        LogTools.info((String)("Starting Gstreamer with camera index: " + this.decklinkID));
        Gst.init();
        String deckLinkIndex = " device-number=" + this.decklinkID + " ";
        this.pipeline = (Pipeline)Gst.parseLaunch((String)("decklinkvideosrc connection=hdmi " + deckLinkIndex + "! timeoverlay ! videorate ! video/x-raw,framerate=60/1 ! identity name=identity ! jpegenc ! .video splitmuxsink muxer=qtmux location=" + videoCaptureFie));
        this.pipeline.getBus().connect(source -> {
            System.out.println("Recieved the EOS on the pipeline!");
            this.gotEOSPlayBin.release();
        });
        this.gotEOSPlayBin.drainPermits();
        Element identity = this.pipeline.getElementByName("identity");
        identity.getStaticPad("sink").addProbe(PadProbeType.BUFFER, (Pad.PROBE)new TimestampProbe());
        this.pipeline.play();
    }

    @Override
    public void restart() throws IOException {
        this.close();
        this.removeLogFiles();
        this.createCaptureInterface();
    }

    @Override
    public void timestampChanged(long newTimestamp) {
        if (this.pipeline != null && latestHardwareTimestamp != System.currentTimeMillis()) {
            this.circularLongMap.insert(System.currentTimeMillis(), newTimestamp);
            latestHardwareTimestamp = System.currentTimeMillis();
        }
    }

    @Override
    public void close() {
        LogTools.info((String)"Signalling recorder to shut down.");
        try {
            LogTools.info((String)"Stopping capture.");
            this.pipeline.sendEvent((Event)new EOSEvent());
            this.gotEOSPlayBin.acquire(1);
            this.pipeline.stop();
            LogTools.info((String)"Closing writer.");
            this.timestampWriter.close();
            LogTools.info((String)"Done.");
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        this.timestampWriter = null;
    }

    public void receivedFrameAtTime(long hardwareTime, long pts, long timeScaleNumerator, long timeScaleDenumerator) {
        if (this.circularLongMap.size() > 0) {
            long robotTimestamp = this.circularLongMap.getValue(true, hardwareTime);
            if (this.frameNumber % 420 == 0) {
                double delayInSeconds = Conversions.nanosecondsToSeconds((long)(this.circularLongMap.getLatestKey() - hardwareTime));
                System.out.println("Delay in Seconds: " + delayInSeconds + " / PresentationTimeStamp: " + pts);
            }
            try {
                if (!WRITTEN_TO_TIMESTAMP) {
                    this.timestampWriter.write(timeScaleNumerator + "\n");
                    this.timestampWriter.write(timeScaleDenumerator + "\n");
                    WRITTEN_TO_TIMESTAMP = true;
                }
                this.timestampWriter.write(robotTimestamp + " " + pts + "\n");
                lastFrameTimestamp = System.nanoTime();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++this.frameNumber;
        }
    }

    @Override
    public long getLastFrameReceivedTimestamp() {
        return lastFrameTimestamp;
    }

    static {
        lastFrameTimestamp = 0L;
        i = 0;
    }

    class TimestampProbe
    implements Pad.PROBE {
        TimestampProbe() {
        }

        public PadProbeReturn probeCallback(Pad pad, PadProbeInfo info) {
            Buffer buffer = info.getBuffer();
            if (buffer.isWritable()) {
                GStreamerVideoDataLogger.this.receivedFrameAtTime(System.currentTimeMillis(), i, 1L, 90000L);
                i += 3001;
                i += 1001;
            }
            return PadProbeReturn.OK;
        }
    }
}

