/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.example;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.robotDataLogger.YoVariableServer;
import us.ihmc.robotDataLogger.logger.DataServerSettings;
import us.ihmc.robotDataLogger.memoryLogger.CircularMemoryLogger;
import us.ihmc.robotDataLogger.util.JVMStatisticsGenerator;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.parameters.XmlParameterReader;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoVariable;

public class MemoryLoggerExample {
    private final XmlParameterReader parameterReader;
    private final YoRegistry registry = new YoRegistry("tester");
    private final YoDouble var1 = new YoDouble("var1", this.registry);
    private final YoDouble var2 = new YoDouble("var2", this.registry);
    private final YoInteger var4 = new YoInteger("var4", this.registry);
    private final YoEnum<TestEnum> var3 = new YoEnum("var3", "", this.registry, TestEnum.class, true);
    private final YoBoolean stop = new YoBoolean("stop", this.registry);
    private final YoInteger echoIn = new YoInteger("echoIn", this.registry);
    private final YoInteger echoOut = new YoInteger("echoOut", this.registry);
    private final YoInteger timeout = new YoInteger("timeout", this.registry);
    private final YoBoolean startVariableSummary = new YoBoolean("startVariableSummary", this.registry);
    private final YoBoolean gc = new YoBoolean("gc", this.registry);
    private final DoubleParameter param1 = new DoubleParameter("param1", this.registry);
    private final DoubleParameter param2 = new DoubleParameter("param2", this.registry);
    private final YoDouble param1Echo = new YoDouble("param1Echo", this.registry);
    private final YoDouble param2Echo = new YoDouble("param2Echo", this.registry);
    private final YoVariableServer server = new YoVariableServer(this.getClass(), null, new DataServerSettings(false), 0.001);
    private final JVMStatisticsGenerator jvmStatisticsGenerator;
    private volatile long timestamp = 0L;

    public MemoryLoggerExample() throws IOException {
        new YoInteger("var5", this.registry);
        new YoEnum("var6", "", this.registry, TestEnum.class, true);
        this.parameterReader = new XmlParameterReader(new InputStream[]{this.getClass().getResourceAsStream("TestParameters.xml")});
        this.server.addBufferListener(new CircularMemoryLogger(new File("/tmp"), 60000));
        this.server.setMainRegistry(this.registry, null);
        this.jvmStatisticsGenerator = new JVMStatisticsGenerator(this.server);
        this.server.createSummary("tester.startVariableSummary");
        this.server.addSummarizedVariable("tester.var1");
        this.server.addSummarizedVariable("tester.var2");
        this.server.addSummarizedVariable((YoVariable)this.var4);
        this.jvmStatisticsGenerator.addVariablesToStatisticsGenerator(this.server);
        this.startVariableSummary.set(false);
        this.jvmStatisticsGenerator.start();
        this.parameterReader.readParametersInRegistry(this.registry);
        ThreadTester tester = new ThreadTester(this.server);
        tester.start();
        this.server.start();
        this.var4.set(5000);
        this.timeout.set(1);
        int i = 0;
        TestEnum[] values = new TestEnum[]{TestEnum.A, TestEnum.B, TestEnum.C, TestEnum.D};
        while (!this.stop.getValue()) {
            this.var1.add(1.0);
            this.var2.sub(1.0);
            this.var4.sub(1);
            if (++i >= values.length) {
                i = 0;
            }
            this.var3.set((Enum)values[i]);
            this.echoOut.set(this.echoIn.getIntegerValue());
            if (this.gc.getBooleanValue()) {
                System.gc();
                this.gc.set(false);
            }
            this.param1Echo.set(this.param1.getValue());
            this.param2Echo.set(this.param2.getValue());
            this.timestamp += Conversions.millisecondsToNanoseconds((long)1L);
            this.server.update(this.timestamp);
            ThreadTools.sleep((long)this.timeout.getIntegerValue());
        }
        tester.running = false;
        try {
            tester.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.jvmStatisticsGenerator.stop();
        this.server.close();
    }

    public static void main(String[] args) throws IOException {
        new MemoryLoggerExample();
    }

    static enum TestEnum {
        A,
        B,
        C,
        D;

    }

    private class ThreadTester
    extends Thread {
        private final YoRegistry registry = new YoRegistry("Thread");
        private final YoDouble A = new YoDouble("A", this.registry);
        private final YoDouble B = new YoDouble("B", this.registry);
        private final YoDouble C = new YoDouble("C", this.registry);
        private final YoEnum<TestEnum> echoThreadIn = new YoEnum("echoThreadIn", this.registry, TestEnum.class, false);
        private final YoEnum<TestEnum> echoThreadOut = new YoEnum("echoThreadOut", this.registry, TestEnum.class, false);
        private final DoubleParameter param1 = new DoubleParameter("threadParam1", this.registry);
        private final DoubleParameter param2 = new DoubleParameter("threadParam2", this.registry);
        private final YoDouble param1Echo = new YoDouble("threadParam1Echo", this.registry);
        private final YoDouble param2Echo = new YoDouble("threadParam2Echo", this.registry);
        public volatile boolean running = true;

        public ThreadTester(YoVariableServer server) {
            server.addRegistry(this.registry, null);
            MemoryLoggerExample.this.parameterReader.readParametersInRegistry(this.registry);
        }

        @Override
        public void run() {
            while (this.running) {
                this.A.set(this.A.getDoubleValue() + 0.5);
                this.B.set(this.B.getDoubleValue() - 0.5);
                this.C.set(this.C.getDoubleValue() * 2.0);
                this.echoThreadOut.set((Enum)((TestEnum)this.echoThreadIn.getEnumValue()));
                this.param1Echo.set(this.param1.getValue());
                this.param2Echo.set(this.param2.getValue());
                MemoryLoggerExample.this.server.update(MemoryLoggerExample.this.timestamp, this.registry);
                ThreadTools.sleep((long)10L);
            }
        }
    }
}

