/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.logger;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import us.ihmc.commons.Conversions;
import us.ihmc.javadecklink.Capture;
import us.ihmc.javadecklink.CaptureHandler;
import us.ihmc.log.LogTools;
import us.ihmc.robotDataLogger.LogProperties;
import us.ihmc.robotDataLogger.logger.VideoDataLoggerInterface;
import us.ihmc.robotDataLogger.logger.YoVariableLoggerOptions;
import us.ihmc.tools.maps.CircularLongMap;

public class BlackmagicVideoDataLogger
extends VideoDataLoggerInterface
implements CaptureHandler {
    private final int decklink;
    private final YoVariableLoggerOptions options;
    private Capture capture;
    private final CircularLongMap circularLongMap = new CircularLongMap(10000);
    private FileWriter timestampWriter;
    private int frame;
    private volatile long lastFrameTimestamp = 0L;

    public BlackmagicVideoDataLogger(String name, String captureType, File logPath, LogProperties logProperties, int decklinkID, YoVariableLoggerOptions options) throws IOException {
        super(logPath, captureType, logProperties, name);
        this.decklink = decklinkID;
        this.options = options;
        this.createCaptureInterface();
    }

    private void createCaptureInterface() {
        File timestampFile = new File(this.timestampData);
        switch (this.options.getVideoCodec()) {
            case AV_CODEC_ID_H264: {
                this.capture = new Capture((CaptureHandler)this, Capture.CodecID.AV_CODEC_ID_H264);
                this.capture.setOption("g", "1");
                this.capture.setOption("crf", String.valueOf(this.options.getCrf()));
                this.capture.setOption("profile", "high");
                this.capture.setOption("coder", "vlc");
                break;
            }
            case AV_CODEC_ID_MJPEG: {
                this.capture = new Capture((CaptureHandler)this, Capture.CodecID.AV_CODEC_ID_MJPEG);
                this.capture.setMJPEGQuality(this.options.getVideoQuality());
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        try {
            this.timestampWriter = new FileWriter(timestampFile);
            this.capture.startCapture(this.videoFile, this.decklink);
        }
        catch (IOException e) {
            this.capture = null;
            if (this.timestampWriter != null) {
                try {
                    this.timestampWriter.close();
                    timestampFile.delete();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.timestampWriter = null;
            LogTools.info((String)"Cannot start capture interface");
            e.printStackTrace();
        }
    }

    @Override
    public void restart() throws IOException {
        this.close();
        this.removeLogFiles();
        this.createCaptureInterface();
    }

    @Override
    public void timestampChanged(long newTimestamp) {
        long hardwareTimestamp;
        if (this.capture != null && (hardwareTimestamp = this.capture.getHardwareTime()) != -1L) {
            this.circularLongMap.insert(hardwareTimestamp, newTimestamp);
        }
    }

    @Override
    public void close() {
        LogTools.info((String)"Signalling recorder to shut down.");
        if (this.capture != null) {
            try {
                LogTools.info((String)"Stopping capture.");
                this.capture.stopCapture();
                LogTools.info((String)"Closing writer.");
                this.timestampWriter.close();
                LogTools.info((String)"Done.");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.capture = null;
            this.timestampWriter = null;
        }
    }

    public void receivedFrameAtTime(long hardwareTime, long pts, long timeScaleNumerator, long timeScaleDenumerator) {
        if (this.circularLongMap.size() > 0) {
            if (this.frame % 600 == 0) {
                double delayInS = Conversions.nanosecondsToSeconds((long)(this.circularLongMap.getLatestKey() - hardwareTime));
                System.out.println("[Decklink " + this.decklink + "] Received frame " + this.frame + ". Delay: " + delayInS + "s. pts: " + pts);
            }
            long robotTimestamp = this.circularLongMap.getValue(true, hardwareTime);
            try {
                if (this.frame == 0) {
                    this.timestampWriter.write(timeScaleNumerator + "\n");
                    this.timestampWriter.write(timeScaleDenumerator + "\n");
                }
                this.timestampWriter.write(robotTimestamp + " " + pts + "\n");
                this.lastFrameTimestamp = System.nanoTime();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++this.frame;
        }
    }

    @Override
    public long getLastFrameReceivedTimestamp() {
        return this.lastFrameTimestamp;
    }
}

