/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.websocket.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import us.ihmc.robotDataLogger.listeners.VariableChangedListener;
import us.ihmc.robotDataLogger.logger.LogAliveListener;
import us.ihmc.robotDataLogger.websocket.server.DataServerIOExceptionHandler;
import us.ihmc.robotDataLogger.websocket.server.DataServerServerContent;
import us.ihmc.robotDataLogger.websocket.server.HTTPDataServerDescriptionServer;
import us.ihmc.robotDataLogger.websocket.server.WebsocketDataBroadcaster;
import us.ihmc.robotDataLogger.websocket.server.WebsocketDataServerFrameHandler;

class WebsocketDataServerInitializer
extends ChannelInitializer<SocketChannel> {
    private static final String WEBSOCKET_PATH = "/websocket";
    private final DataServerServerContent logServerContent;
    private final WebsocketDataBroadcaster broadcaster;
    private final VariableChangedListener variableChangedListener;
    private final LogAliveListener logAliveListener;
    private final int dataSize;
    private final int numberOfRegistryBuffers;

    public WebsocketDataServerInitializer(DataServerServerContent logServerContent, WebsocketDataBroadcaster broadcaster, VariableChangedListener variableChangedListener, LogAliveListener logAliveListener, int dataSize, int numberOfRegistryBuffers) {
        this.logServerContent = logServerContent;
        this.broadcaster = broadcaster;
        this.dataSize = dataSize;
        this.variableChangedListener = variableChangedListener;
        this.logAliveListener = logAliveListener;
        this.numberOfRegistryBuffers = numberOfRegistryBuffers;
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast(new ChannelHandler[]{new DataServerIOExceptionHandler()});
        pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
        pipeline.addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler(WEBSOCKET_PATH, null, true)});
        pipeline.addLast(new ChannelHandler[]{new HTTPDataServerDescriptionServer(this.logServerContent)});
        pipeline.addLast(new ChannelHandler[]{new WebsocketDataServerFrameHandler(this.broadcaster, this.dataSize, this.numberOfRegistryBuffers, this.variableChangedListener, this.logAliveListener)});
    }
}

