/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.ihmc.idl.serializers.extra.YAMLSerializer;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.robotDataLogger.Host;
import us.ihmc.robotDataLogger.StaticHostList;
import us.ihmc.robotDataLogger.StaticHostListPubSubType;
import us.ihmc.robotDataLogger.websocket.client.discovery.HTTPDataServerDescription;

public class StaticHostListLoader {
    public static final String location = System.getProperty("user.home") + File.separator + ".ihmc" + File.separator + "ControllerHosts.yaml";

    public static List<HTTPDataServerDescription> load() {
        File in = new File(location);
        if (in.exists()) {
            try {
                String data = new String(Files.readAllBytes(in.toPath()), Charset.defaultCharset());
                return StaticHostListLoader.load(data);
            }
            catch (IOException e) {
                LogTools.warn((String)("Cannot load hosts list: " + e.getMessage()));
            }
        } else {
            LogTools.warn((String)("Cannot find " + location + ". Starting with empty list of hosts."));
        }
        return Collections.emptyList();
    }

    public static StaticHostList loadHostList(String data) throws IOException {
        YAMLSerializer ser = new YAMLSerializer((TopicDataType)new StaticHostListPubSubType());
        ser.setAddTypeAsRootNode(false);
        return (StaticHostList)((Object)ser.deserialize(data));
    }

    public static List<HTTPDataServerDescription> load(String data) {
        try {
            ArrayList<HTTPDataServerDescription> list = new ArrayList<HTTPDataServerDescription>();
            StaticHostList hostList = StaticHostListLoader.loadHostList(data);
            for (Host host : hostList.getHosts()) {
                HTTPDataServerDescription description = new HTTPDataServerDescription(host.getHostnameAsString(), host.getPort(), host.getCameras(), true);
                list.add(description);
            }
            return list;
        }
        catch (IOException e) {
            LogTools.warn((String)("Cannot load hosts list: " + e.getMessage()));
            return Collections.emptyList();
        }
    }

    public static String toString(List<HTTPDataServerDescription> list) throws IOException {
        StaticHostList staticHostList = new StaticHostList();
        for (HTTPDataServerDescription description : list) {
            Host host = (Host)((Object)staticHostList.getHosts().add());
            host.setHostname(description.getHost());
            host.setPort(description.getPort());
            if (description.getCameraList() == null) continue;
            for (int i = 0; i < description.getCameraList().size(); ++i) {
                host.getCameras().add(description.getCameraList().get(i));
            }
        }
        return StaticHostListLoader.toString(staticHostList);
    }

    public static String toString(StaticHostList staticHostList) throws IOException {
        YAMLSerializer ser = new YAMLSerializer((TopicDataType)new StaticHostListPubSubType());
        ser.setAddTypeAsRootNode(false);
        return ser.serializeToString((Object)staticHostList);
    }

    public static void save(List<HTTPDataServerDescription> list) throws IOException {
        File in = new File(location);
        if (!in.getParentFile().exists()) {
            in.getParentFile().mkdirs();
        }
        Files.write(in.toPath(), StaticHostListLoader.toString(list).getBytes(), new OpenOption[0]);
    }
}

