/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.websocket.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import us.ihmc.robotDataLogger.websocket.server.DataServerServerContent;

class HTTPDataServerDescriptionServer
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final DataServerServerContent logServerContent;

    public HTTPDataServerDescriptionServer(DataServerServerContent logServerContent) {
        this.logServerContent = logServerContent;
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest req) throws Exception {
        if (!req.decoderResult().isSuccess()) {
            HTTPDataServerDescriptionServer.sendHttpResponse(ctx, req, (FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST));
            return;
        }
        if (req.method() != HttpMethod.GET) {
            HTTPDataServerDescriptionServer.sendHttpResponse(ctx, req, (FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN));
            return;
        }
        if ("/".equals(req.uri()) || "/index.html".equals(req.uri())) {
            HTTPDataServerDescriptionServer.sendContent(ctx, req, this.logServerContent.getIndex(), this.logServerContent.getIndexContentType());
        } else if ("/announcement.json".equals(req.uri())) {
            HTTPDataServerDescriptionServer.sendContent(ctx, req, this.logServerContent.getAnnouncement(), this.logServerContent.getAnnouncementContentType());
        } else if ("/handshake.json".equals(req.uri())) {
            HTTPDataServerDescriptionServer.sendContent(ctx, req, this.logServerContent.getHandshake(), this.logServerContent.getHandshakeContentType());
        } else if (this.logServerContent.hasModel() && "/model.sdf".equals(req.uri())) {
            HTTPDataServerDescriptionServer.sendContent(ctx, req, this.logServerContent.getModel(), this.logServerContent.getModelContentType());
        } else if (this.logServerContent.hasResourceZip() && "/resources.zip".equals(req.uri())) {
            HTTPDataServerDescriptionServer.sendContent(ctx, req, this.logServerContent.getResourceZip(), this.logServerContent.getResourceZipContentType());
        } else {
            HTTPDataServerDescriptionServer.sendHttpResponse(ctx, req, (FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND));
        }
    }

    private static void sendContent(ChannelHandlerContext ctx, FullHttpRequest req, ByteBuf content, String contentType) {
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, content);
        res.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
        HttpUtil.setContentLength((HttpMessage)res, (long)content.readableBytes());
        HTTPDataServerDescriptionServer.sendHttpResponse(ctx, req, (FullHttpResponse)res);
    }

    private static void sendHttpResponse(ChannelHandlerContext ctx, FullHttpRequest req, FullHttpResponse res) {
        if (res.status().code() != 200) {
            ByteBuf buf = Unpooled.copiedBuffer((CharSequence)res.status().toString(), (Charset)CharsetUtil.UTF_8);
            res.content().writeBytes(buf);
            buf.release();
            HttpUtil.setContentLength((HttpMessage)res, (long)res.content().readableBytes());
        }
        ChannelFuture f = ctx.channel().writeAndFlush((Object)res);
        if (!HttpUtil.isKeepAlive((HttpMessage)req) || res.status().code() != 200) {
            f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

