/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger;

import java.io.IOException;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;
import us.ihmc.robotDataLogger.Video;

public class VideoPubSubType
implements TopicDataType<Video> {
    public static final String name = "us::ihmc::robotDataLogger::Video";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public final String getDefinitionChecksum() {
        return "6d7fe7d3d8b07e957ab466dc84e2d5f653d3e2cceab5599496e96b3271adb0ea";
    }

    public final String getDefinitionVersion() {
        return "local";
    }

    public void serialize(Video data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        VideoPubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, Video data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        VideoPubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return VideoPubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(Video data) {
        return VideoPubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(Video data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        return current_alignment - initial_alignment;
    }

    public static void write(Video data, CDR cdr) {
        cdr.write_type_7(data.getHasTimebase());
    }

    public static void read(Video data, CDR cdr) {
        data.setHasTimebase(cdr.read_type_7());
    }

    public final void serialize(Video data, InterchangeSerializer ser) {
        ser.write_type_7("hasTimebase", data.getHasTimebase());
    }

    public final void deserialize(InterchangeSerializer ser, Video data) {
        data.setHasTimebase(ser.read_type_7("hasTimebase"));
    }

    public static void staticCopy(Video src, Video dest) {
        dest.set(src);
    }

    public Video createData() {
        return new Video();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)VideoPubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(Video data, CDR cdr) {
        VideoPubSubType.write(data, cdr);
    }

    public void deserialize(Video data, CDR cdr) {
        VideoPubSubType.read(data, cdr);
    }

    public void copy(Video src, Video dest) {
        VideoPubSubType.staticCopy(src, dest);
    }

    public VideoPubSubType newInstance() {
        return new VideoPubSubType();
    }
}

