/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.logger;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import org.apache.commons.io.FileUtils;
import us.ihmc.log.LogTools;
import us.ihmc.robotDataLogger.logger.LogPropertiesReader;

public class YoVariableLogRotator {
    private static final DateTimeFormatter timestampFormat = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");

    public static void rotate(Path root, int logsToKeep) throws IOException {
        LogTools.info((String)("Rotating logs in " + root + ". Keeping " + logsToKeep + " logs"));
        Files.walk(root, new FileVisitOption[0]).filter(p -> Files.exists(p.resolve("robotData.log"), new LinkOption[0])).map(p -> new LogAndTimestamp((Path)p)).sorted(Comparator.reverseOrder()).skip(logsToKeep).forEach(t -> t.delete());
    }

    public static void main(String[] args) throws IOException {
        Path dir = Paths.get(System.getProperty("user.home"), "robotLogs");
        YoVariableLogRotator.rotate(dir, 6);
    }

    private static class LogAndTimestamp
    implements Comparable<LogAndTimestamp> {
        private final Path directory;
        private final LocalDateTime timestamp;

        public LogAndTimestamp(Path directory) {
            this.directory = directory;
            LocalDateTime timestamp = LocalDateTime.MIN;
            try {
                LogPropertiesReader reader = new LogPropertiesReader(directory.resolve("robotData.log").toFile());
                if (reader.getTimestampAsString().trim().isEmpty()) {
                    LogTools.warn((String)("Empty timestamp for log in " + directory + ", assuming LocalDateTime.MIN"));
                } else {
                    timestamp = LocalDateTime.parse(reader.getTimestampAsString(), timestampFormat);
                }
            }
            catch (Exception e) {
                LogTools.warn((String)("Could not parse timestamp for log in " + directory + ", assuming LocalDateTime.MIN"));
            }
            this.timestamp = timestamp;
        }

        public void delete() {
            LogTools.info((String)("Deleting " + this));
            try {
                FileUtils.deleteDirectory((File)this.directory.toFile());
            }
            catch (IOException e) {
                System.err.println("Cannot delete " + this.directory);
            }
        }

        @Override
        public int compareTo(LogAndTimestamp o) {
            return this.timestamp.compareTo(o.timestamp);
        }

        public String toString() {
            return this.timestamp + ": " + this.directory.toString();
        }
    }
}

