/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger;

import java.io.IOException;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;
import us.ihmc.robotDataLogger.JointDefinition;
import us.ihmc.robotDataLogger.JointType;

public class JointDefinitionPubSubType
implements TopicDataType<JointDefinition> {
    public static final String name = "us::ihmc::robotDataLogger::JointDefinition";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public final String getDefinitionChecksum() {
        return "47788074ef85fc4d41967bc5006da101900e00ccaa28e8af31c5da7ecd907d3e";
    }

    public final String getDefinitionVersion() {
        return "local";
    }

    public void serialize(JointDefinition data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        JointDefinitionPubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, JointDefinition data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        JointDefinitionPubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return JointDefinitionPubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(JointDefinition data) {
        return JointDefinitionPubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(JointDefinition data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getName().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        return current_alignment - initial_alignment;
    }

    public static void write(JointDefinition data, CDR cdr) {
        if (data.getName().length() > 255) {
            throw new RuntimeException("name field exceeds the maximum length");
        }
        cdr.write_type_d(data.getName());
        cdr.write_type_c(data.getType().ordinal());
    }

    public static void read(JointDefinition data, CDR cdr) {
        cdr.read_type_d(data.getName());
        data.setType(JointType.values[cdr.read_type_c()]);
    }

    public final void serialize(JointDefinition data, InterchangeSerializer ser) {
        ser.write_type_d("name", data.getName());
        ser.write_type_c("type", (Enum)data.getType());
    }

    public final void deserialize(InterchangeSerializer ser, JointDefinition data) {
        ser.read_type_d("name", data.getName());
        data.setType((JointType)ser.read_type_c("type", JointType.class));
    }

    public static void staticCopy(JointDefinition src, JointDefinition dest) {
        dest.set(src);
    }

    public JointDefinition createData() {
        return new JointDefinition();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)JointDefinitionPubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(JointDefinition data, CDR cdr) {
        JointDefinitionPubSubType.write(data, cdr);
    }

    public void deserialize(JointDefinition data, CDR cdr) {
        JointDefinitionPubSubType.read(data, cdr);
    }

    public void copy(JointDefinition src, JointDefinition dest) {
        JointDefinitionPubSubType.staticCopy(src, dest);
    }

    public JointDefinitionPubSubType newInstance() {
        return new JointDefinitionPubSubType();
    }
}

