/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.logger;

import com.martiansoftware.jsap.JSAPException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import org.apache.commons.lang3.SystemUtils;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.log.LogTools;
import us.ihmc.robotDataLogger.Announcement;
import us.ihmc.robotDataLogger.StaticHostListLoader;
import us.ihmc.robotDataLogger.interfaces.DataServerDiscoveryListener;
import us.ihmc.robotDataLogger.logger.YoVariableLogger;
import us.ihmc.robotDataLogger.logger.YoVariableLoggerOptions;
import us.ihmc.robotDataLogger.websocket.client.discovery.DataServerDiscoveryClient;
import us.ihmc.robotDataLogger.websocket.client.discovery.HTTPDataServerConnection;

public class YoVariableLoggerDispatcher
implements DataServerDiscoveryListener {
    private final File lockFile = new File(System.getProperty("user.home") + File.separator + "loggerDispatcher.lock");
    private final DataServerDiscoveryClient discoveryClient;
    private final Object lock = new Object();
    private final HashSet<HashAnnouncement> activeLogSessions = new HashSet();
    private final YoVariableLoggerOptions options;

    public YoVariableLoggerDispatcher(YoVariableLoggerOptions options) throws IOException {
        if (this.lockFile.exists()) {
            LogTools.info((String)"Maybe if you weren't so full of yourself you would have checked if the logger was already running");
            LogTools.info((String)("Check the file: " + this.lockFile.getAbsolutePath() + " or run (ps aux | grep java)"));
            System.exit(0);
        }
        this.lockFile.createNewFile();
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        if (!SystemUtils.OS_NAME.contains("Windows")) {
            perms.add(PosixFilePermission.OWNER_READ);
            Files.setPosixFilePermissions(this.lockFile.toPath(), perms);
        }
        LogTools.info((String)"Created Logger lock file");
        this.options = options;
        LogTools.info((String)"Starting YoVariableLoggerDispatcher");
        boolean enableAutoDiscovery = !options.isDisableAutoDiscovery();
        this.discoveryClient = new DataServerDiscoveryClient(this, enableAutoDiscovery);
        this.discoveryClient.addHosts(StaticHostListLoader.load());
        LogTools.info((String)"Client started, waiting for data server sessions");
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutDownLockFile, "ShutdownThread"));
        ThreadTools.sleepForever();
    }

    private void shutDownLockFile() {
        this.lockFile.delete();
        LogTools.info((String)"Interrupted by Ctrl+C, deleting lock file");
    }

    public static void main(String[] args) throws JSAPException, IOException, InterruptedException {
        YoVariableLoggerOptions options = YoVariableLoggerOptions.parse(args);
        new YoVariableLoggerDispatcher(options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connected(HTTPDataServerConnection connection) {
        Object object = this.lock;
        synchronized (object) {
            Announcement announcement = connection.getAnnouncement();
            HashAnnouncement hashAnnouncement = new HashAnnouncement(announcement);
            LogTools.warn((String)"New control session came online: ( {} ({}))", (Object)connection.getTarget(), (Object)announcement.getHostNameAsString());
            if (this.activeLogSessions.contains(hashAnnouncement)) {
                LogTools.warn((String)("A logging sessions for " + announcement.getNameAsString() + " is already started."));
            } else if (announcement.getLog()) {
                try {
                    new YoVariableLogger(connection, this.options, request -> this.finishedLog((Announcement)((Object)request)));
                    this.activeLogSessions.add(hashAnnouncement);
                    LogTools.info((String)("Logging session started for " + announcement.getNameAsString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                LogTools.warn((String)"Not logging the above session");
            }
        }
    }

    @Override
    public void disconnected(HTTPDataServerConnection connection) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishedLog(Announcement request) {
        Object object = this.lock;
        synchronized (object) {
            ThreadTools.sleep((long)2000L);
            HashAnnouncement hashRequest = new HashAnnouncement(request);
            this.activeLogSessions.remove(hashRequest);
            LogTools.info((String)("Logging session for " + request.getNameAsString() + " has finished.\n"));
        }
    }

    private static class HashAnnouncement {
        private final Announcement announcement;

        public HashAnnouncement(Announcement announcement) {
            this.announcement = announcement;
        }

        public boolean equals(Object other) {
            if (other instanceof HashAnnouncement) {
                return this.announcement.equals((Object)((HashAnnouncement)other).announcement);
            }
            return false;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.announcement.getIdentifierAsString().hashCode();
            result = 31 * result + (this.announcement.getLog() ? 1231 : 1237);
            result = 31 * result + this.announcement.getNameAsString().hashCode();
            result = 31 * result + this.announcement.getReconnectKeyAsString().hashCode();
            return result;
        }
    }
}

