/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.websocket.client;

import io.netty.buffer.ByteBuf;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import us.ihmc.idl.serializers.extra.JSONSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.robotDataLogger.Announcement;
import us.ihmc.robotDataLogger.Handshake;
import us.ihmc.robotDataLogger.HandshakePubSubType;
import us.ihmc.robotDataLogger.YoVariableClientImplementation;
import us.ihmc.robotDataLogger.handshake.IDLYoVariableHandshakeParser;
import us.ihmc.robotDataLogger.interfaces.CommandListener;
import us.ihmc.robotDataLogger.interfaces.DataConsumer;
import us.ihmc.robotDataLogger.interfaces.VariableChangedProducer;
import us.ihmc.robotDataLogger.listeners.TimestampListener;
import us.ihmc.robotDataLogger.util.DebugRegistry;
import us.ihmc.robotDataLogger.websocket.client.WebsocketDataServerClient;
import us.ihmc.robotDataLogger.websocket.client.discovery.HTTPDataServerConnection;
import us.ihmc.robotDataLogger.websocket.client.discovery.HTTPDataServerDescription;
import us.ihmc.robotDataLogger.websocket.command.DataServerCommand;

public class WebsocketDataConsumer
implements DataConsumer {
    private final Object lock = new Object();
    private HTTPDataServerConnection connection;
    private WebsocketDataServerClient session;
    private boolean closed = false;
    private final int timeoutInMs;
    private IDLYoVariableHandshakeParser parser;
    private YoVariableClientImplementation yoVariableClient;
    private TimestampListener timestampListener;
    private DebugRegistry debugRegistry;

    public WebsocketDataConsumer(HTTPDataServerConnection initialConnection, int timeoutInMs) {
        this.connection = initialConnection;
        this.timeoutInMs = timeoutInMs;
    }

    private ByteBuf getResource(String path) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.connection.isConnected()) {
                throw new IOException("Not connected");
            }
            Future<ByteBuf> resourceFuture = this.connection.requestResource(path);
            try {
                return resourceFuture.get(this.timeoutInMs, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    public byte[] getModelFile() throws IOException {
        ByteBuf model = this.getResource("/model.sdf");
        byte[] retVal = new byte[model.readableBytes()];
        model.readBytes(retVal);
        return retVal;
    }

    @Override
    public byte[] getResourceZip() throws IOException {
        ByteBuf resourceZip = this.getResource("/resources.zip");
        byte[] retVal = new byte[resourceZip.readableBytes()];
        resourceZip.readBytes(retVal);
        return retVal;
    }

    @Override
    public Handshake getHandshake() throws IOException {
        ByteBuf handshake = this.getResource("/handshake.json");
        JSONSerializer serializer = new JSONSerializer((TopicDataType)new HandshakePubSubType());
        return (Handshake)((Object)serializer.deserialize(handshake.toString(CharsetUtil.UTF_8)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startSession(IDLYoVariableHandshakeParser parser, YoVariableClientImplementation yoVariableClient, VariableChangedProducer variableChangedProducer, TimestampListener timeStampListener, CommandListener clearLogListener, DebugRegistry debugRegistry) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.connection.isConnected()) {
                throw new IOException("Not connected");
            }
            this.connection.take();
            this.parser = parser;
            this.timestampListener = timeStampListener;
            this.yoVariableClient = yoVariableClient;
            this.debugRegistry = debugRegistry;
            this.session = new WebsocketDataServerClient(this.connection, parser, timeStampListener, yoVariableClient, this.timeoutInMs, debugRegistry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSessionActive() {
        Object object = this.lock;
        synchronized (object) {
            if (this.session == null) {
                return false;
            }
            return this.session.isActive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnectSession() {
        Object object = this.lock;
        synchronized (object) {
            if (this.session == null) {
                throw new RuntimeException("Session not started");
            }
            this.session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.connection.isConnected()) {
                this.connection.close();
            }
            if (this.session != null && this.session.isActive()) {
                this.session.close();
            }
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        Object object = this.lock;
        synchronized (object) {
            return this.closed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reconnect() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.session != null && this.session.isActive()) {
                throw new RuntimeException("Session is still active");
            }
            try {
                HTTPDataServerDescription oldDescription = this.connection.getTarget();
                HTTPDataServerConnection newConnection = HTTPDataServerConnection.connect(oldDescription.getHost(), oldDescription.getPort());
                newConnection.close();
                Announcement announcement = newConnection.getAnnouncement();
                Announcement oldAnnouncement = this.connection.getAnnouncement();
                if (announcement.getReconnectKeyAsString().equals(oldAnnouncement.getReconnectKeyAsString())) {
                    this.connection = newConnection;
                    this.session = new WebsocketDataServerClient(this.connection, this.parser, this.timestampListener, this.yoVariableClient, this.timeoutInMs, this.debugRegistry);
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeVariableChangeRequest(int identifier, double valueAsDouble) {
        Object object = this.lock;
        synchronized (object) {
            if (this.session != null && this.session.isActive()) {
                this.session.writeVariableChangeRequest(identifier, valueAsDouble);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendCommand(DataServerCommand command, int argument) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.session != null && this.session.isActive()) {
                this.session.sendCommand(command, argument);
            }
        }
    }

    public void setVariableSynchronizer(Object variableSynchronizer) {
        this.session.setVariableSynchronizer(variableSynchronizer);
    }
}

