/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.websocket.server;

import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import us.ihmc.concurrent.Builder;
import us.ihmc.concurrent.ConcurrentRingBuffer;
import us.ihmc.pubsub.common.SerializedPayload;
import us.ihmc.robotDataLogger.dataBuffers.CustomLogDataPublisherType;
import us.ihmc.robotDataLogger.dataBuffers.LoggerDebugRegistry;
import us.ihmc.robotDataLogger.dataBuffers.RegistrySendBuffer;
import us.ihmc.robotDataLogger.dataBuffers.RegistrySendBufferBuilder;
import us.ihmc.robotDataLogger.interfaces.RegistryPublisher;
import us.ihmc.robotDataLogger.websocket.server.WebsocketDataBroadcaster;

class WebsocketRegistryPublisher
implements RegistryPublisher {
    private static final int BUFFER_CAPACITY = 128;
    private long uid = 0L;
    private final ConcurrentRingBuffer<RegistrySendBuffer> ringBuffer;
    private final WebsocketDataBroadcaster broadcaster;
    private final LoggerDebugRegistry loggerDebugRegistry;
    private final EventLoopGroup eventLoopGroup;
    private final VariableUpdateThread variableUpdateThread = new VariableUpdateThread();
    private final CustomLogDataPublisherType publisherType;
    private final SerializedPayload serializedPayload;
    private ScheduledFuture<?> scheduledFuture;
    private final int numberOfVariables;
    private final int bufferID;

    public WebsocketRegistryPublisher(EventLoopGroup workerGroup, RegistrySendBufferBuilder builder, WebsocketDataBroadcaster broadcaster, int bufferID) {
        this.broadcaster = broadcaster;
        this.ringBuffer = new ConcurrentRingBuffer((Builder)builder, 128);
        this.eventLoopGroup = workerGroup;
        this.loggerDebugRegistry = builder.getLoggerDebugRegistry();
        this.numberOfVariables = builder.getNumberOfVariables();
        this.bufferID = bufferID;
        this.publisherType = new CustomLogDataPublisherType(builder.getNumberOfVariables(), builder.getNumberOfJointStates());
        this.serializedPayload = new SerializedPayload(this.publisherType.getMaximumTypeSize());
    }

    public int getMaximumBufferSize() {
        return this.publisherType.getMaximumTypeSize();
    }

    @Override
    public void start() {
        this.scheduledFuture = this.eventLoopGroup.scheduleAtFixedRate((Runnable)this.variableUpdateThread, 0L, 1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        this.scheduledFuture.cancel(false);
        try {
            this.scheduledFuture.await(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void update(long timestamp) {
        RegistrySendBuffer buffer = (RegistrySendBuffer)this.ringBuffer.next();
        if (buffer != null) {
            buffer.updateBufferFromVariables(timestamp, this.uid, this.numberOfVariables);
            this.ringBuffer.commit();
        } else {
            this.loggerDebugRegistry.circularBufferFull();
        }
        ++this.uid;
    }

    private class VariableUpdateThread
    implements Runnable {
        private long previousUid = -1L;

        private VariableUpdateThread() {
        }

        @Override
        public void run() {
            try {
                while (WebsocketRegistryPublisher.this.ringBuffer.poll()) {
                    RegistrySendBuffer buffer = (RegistrySendBuffer)WebsocketRegistryPublisher.this.ringBuffer.read();
                    if (buffer != null) {
                        WebsocketRegistryPublisher.this.serializedPayload.getData().clear();
                        WebsocketRegistryPublisher.this.publisherType.serialize(buffer, WebsocketRegistryPublisher.this.serializedPayload);
                        WebsocketRegistryPublisher.this.broadcaster.write(WebsocketRegistryPublisher.this.bufferID, buffer.getTimestamp(), WebsocketRegistryPublisher.this.serializedPayload.getData());
                        if (this.previousUid != -1L && buffer.getUid() != this.previousUid + 1L) {
                            WebsocketRegistryPublisher.this.loggerDebugRegistry.lostTickInCircularBuffer();
                        }
                        this.previousUid = buffer.getUid();
                    }
                    WebsocketRegistryPublisher.this.ringBuffer.flush();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

