/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger;

import java.io.IOException;
import us.ihmc.idl.CDR;
import us.ihmc.idl.IDLSequence;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;
import us.ihmc.robotDataLogger.LogData;
import us.ihmc.robotDataLogger.LogDataType;

public class LogDataPubSubType
implements TopicDataType<LogData> {
    public static final String name = "us::ihmc::robotDataLogger::LogData";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public void serialize(LogData data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        LogDataPubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, LogData data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        LogDataPubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return LogDataPubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 8 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += 8 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += 8 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 100 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 800 + CDR.alignment((int)current_alignment, (int)8);
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(LogData data) {
        return LogDataPubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(LogData data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 8 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += 8 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += 8 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += data.getData().size() * 1 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += data.getJointStates().size() * 8 + CDR.alignment((int)current_alignment, (int)8);
        return current_alignment - initial_alignment;
    }

    public static void write(LogData data, CDR cdr) {
        cdr.write_type_11(data.getUid());
        cdr.write_type_11(data.getTimestamp());
        cdr.write_type_11(data.getTransmitTime());
        cdr.write_type_c(data.getType().ordinal());
        cdr.write_type_2(data.getRegistry());
        cdr.write_type_2(data.getOffset());
        cdr.write_type_2(data.getNumberOfVariables());
        if (data.getData().size() > 100) {
            throw new RuntimeException("data field exceeds the maximum length");
        }
        cdr.write_type_e((IDLSequence)data.getData());
        if (data.getJointStates().size() > 100) {
            throw new RuntimeException("jointStates field exceeds the maximum length");
        }
        cdr.write_type_e((IDLSequence)data.getJointStates());
    }

    public static void read(LogData data, CDR cdr) {
        data.setUid(cdr.read_type_11());
        data.setTimestamp(cdr.read_type_11());
        data.setTransmitTime(cdr.read_type_11());
        data.setType(LogDataType.values[cdr.read_type_c()]);
        data.setRegistry(cdr.read_type_2());
        data.setOffset(cdr.read_type_2());
        data.setNumberOfVariables(cdr.read_type_2());
        cdr.read_type_e((IDLSequence)data.getData());
        cdr.read_type_e((IDLSequence)data.getJointStates());
    }

    public final void serialize(LogData data, InterchangeSerializer ser) {
        ser.write_type_11("uid", data.getUid());
        ser.write_type_11("timestamp", data.getTimestamp());
        ser.write_type_11("transmitTime", data.getTransmitTime());
        ser.write_type_c("type", (Enum)data.getType());
        ser.write_type_2("registry", data.getRegistry());
        ser.write_type_2("offset", data.getOffset());
        ser.write_type_2("numberOfVariables", data.getNumberOfVariables());
        ser.write_type_e("data", (IDLSequence)data.getData());
        ser.write_type_e("jointStates", (IDLSequence)data.getJointStates());
    }

    public final void deserialize(InterchangeSerializer ser, LogData data) {
        data.setUid(ser.read_type_11("uid"));
        data.setTimestamp(ser.read_type_11("timestamp"));
        data.setTransmitTime(ser.read_type_11("transmitTime"));
        data.setType((LogDataType)ser.read_type_c("type", LogDataType.class));
        data.setRegistry(ser.read_type_2("registry"));
        data.setOffset(ser.read_type_2("offset"));
        data.setNumberOfVariables(ser.read_type_2("numberOfVariables"));
        ser.read_type_e("data", (IDLSequence)data.getData());
        ser.read_type_e("jointStates", (IDLSequence)data.getJointStates());
    }

    public static void staticCopy(LogData src, LogData dest) {
        dest.set(src);
    }

    public LogData createData() {
        return new LogData();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)LogDataPubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(LogData data, CDR cdr) {
        LogDataPubSubType.write(data, cdr);
    }

    public void deserialize(LogData data, CDR cdr) {
        LogDataPubSubType.read(data, cdr);
    }

    public void copy(LogData src, LogData dest) {
        LogDataPubSubType.staticCopy(src, dest);
    }

    public LogDataPubSubType newInstance() {
        return new LogDataPubSubType();
    }
}

