/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.dataBuffers;

import java.io.IOException;
import java.nio.ByteBuffer;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;
import us.ihmc.robotDataLogger.LogDataType;
import us.ihmc.robotDataLogger.dataBuffers.RegistrySendBuffer;
import us.ihmc.tools.compression.CompressionImplementation;
import us.ihmc.tools.compression.CompressionImplementationFactory;

public class CustomLogDataPublisherType
implements TopicDataType<RegistrySendBuffer> {
    public static final String name = "us::ihmc::robotDataLogger::LogData";
    private final int numberOfVariables;
    private final int numberOfStates;
    private final ByteBuffer compressBuffer;
    private final CompressionImplementation compressor;
    private final CDR serializeCDR = new CDR();

    public CustomLogDataPublisherType(int numberOfVariables, int numberOfStates) {
        this.numberOfVariables = numberOfVariables;
        this.numberOfStates = numberOfStates;
        this.compressor = CompressionImplementationFactory.instance();
        this.compressBuffer = this.compressor.supportsDirectOutput() ? null : ByteBuffer.allocate(this.compressor.maxCompressedLength(numberOfVariables * 8));
    }

    private void compressDirect(ByteBuffer databuffer, SerializedPayload serializedPayload) {
        ByteBuffer serializeBuffer = serializedPayload.getData();
        this.serializeCDR.write_type_2(0);
        int sizePosition = serializeBuffer.position() - 4;
        int written = this.compressor.compress(databuffer, serializeBuffer);
        serializeBuffer.putInt(sizePosition, written);
    }

    private void compressJavaBuffer(ByteBuffer databuffer, SerializedPayload serializedPayload) throws IOException {
        this.compressBuffer.clear();
        this.compressor.compress(databuffer, this.compressBuffer);
        this.compressBuffer.flip();
        this.serializeCDR.write_type_2(this.compressBuffer.remaining());
        serializedPayload.getData().put(this.compressBuffer);
    }

    public void serialize(RegistrySendBuffer data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        this.serializeCDR.write_type_11(data.getUid());
        this.serializeCDR.write_type_11(data.getTimestamp());
        this.serializeCDR.write_type_11(data.getTransmitTime());
        this.serializeCDR.write_type_c(data.getType().ordinal());
        this.serializeCDR.write_type_2(data.getRegistryID());
        this.serializeCDR.write_type_2(data.getNumberOfVariables());
        if (data.getType() == LogDataType.DATA_PACKET) {
            if (this.compressor.supportsDirectOutput()) {
                this.compressDirect(data.getBuffer(), serializedPayload);
            } else {
                this.compressJavaBuffer(data.getBuffer(), serializedPayload);
            }
            double[] jointstates = data.getJointStates();
            this.serializeCDR.write_type_2(jointstates.length);
            for (int i = 0; i < jointstates.length; ++i) {
                this.serializeCDR.write_type_6(jointstates[i]);
            }
        } else {
            this.serializeCDR.write_type_2(0);
            this.serializeCDR.write_type_2(0);
        }
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, RegistrySendBuffer data) throws IOException {
        throw new RuntimeException("Not implemented");
    }

    public final void serialize(RegistrySendBuffer data, InterchangeSerializer ser) {
        throw new RuntimeException("Not implemented");
    }

    public final void deserialize(InterchangeSerializer ser, RegistrySendBuffer data) {
        throw new RuntimeException("Not implemented");
    }

    public RegistrySendBuffer createData() {
        return null;
    }

    public int getMaximumTypeSize() {
        return CustomLogDataPublisherType.getTypeSize(this.compressor.maxCompressedLength(this.numberOfVariables * 8), this.numberOfStates);
    }

    public int getTypeSize() {
        return CustomLogDataPublisherType.getTypeSize(this.compressor.maxCompressedLength(this.numberOfVariables * 8), this.numberOfStates);
    }

    public static int getTypeSize(int maxCompressedSize, int numberOfStates) {
        int current_alignment = 0;
        current_alignment += 8 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += 8 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += 8 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += maxCompressedSize + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += numberOfStates * 8 + CDR.alignment((int)current_alignment, (int)8);
        return CDR.getTypeSize((int)current_alignment);
    }

    public String getName() {
        return name;
    }

    public CustomLogDataPublisherType newInstance() {
        return new CustomLogDataPublisherType(this.numberOfVariables, this.numberOfStates);
    }

    public void serialize(RegistrySendBuffer data, CDR cdr) {
        throw new RuntimeException("Not implemented");
    }

    public void deserialize(RegistrySendBuffer data, CDR cdr) {
        throw new RuntimeException("Not implemented");
    }

    public void copy(RegistrySendBuffer src, RegistrySendBuffer dest) {
        throw new RuntimeException("Not implemented");
    }
}

