/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.publisher.logger.ui;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.Date;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Stage;
import us.ihmc.publisher.logger.ui.LoggerDeployController;
import us.ihmc.publisher.logger.ui.LoggerDeployScript;
import us.ihmc.publisher.logger.utils.TeeStream;

public class LoggerDeployApplication
extends Application {
    private static final URL uiDescription = LoggerDeployApplication.class.getResource("LoggerSetup.fxml");

    public static void open(String loggerDistribution, LoggerDeployScript deployScript, Scene scene) {
        try {
            FXMLLoader loader = new FXMLLoader(uiDescription);
            Parent root = (Parent)loader.load();
            LoggerDeployController controller = (LoggerDeployController)loader.getController();
            controller.setLoggerDistribution(loggerDistribution);
            controller.setDeployScript(deployScript);
            Stage stage = new Stage();
            stage.setTitle("Logger deployment");
            stage.initOwner(scene.getWindow());
            stage.initModality(Modality.APPLICATION_MODAL);
            stage.setScene(new Scene(root, 1280.0, 900.0));
            stage.show();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void start(Stage stage) throws IOException {
        this.redirectOutput();
        FXMLLoader loader = new FXMLLoader(uiDescription);
        Parent root = (Parent)loader.load();
        LoggerDeployController controller = (LoggerDeployController)loader.getController();
        controller.setDeployScript(new LoggerDeployScript(){});
        controller.setLoggerDistribution((String)this.getParameters().getNamed().get("logger-dist"));
        Scene scene = new Scene(root, 1280.0, 900.0);
        stage.setTitle("Logger deployment");
        stage.setScene(scene);
        stage.show();
    }

    private void redirectOutput() throws FileNotFoundException {
        PrintStream log = new PrintStream(new FileOutputStream("logger-deploy.log", true));
        TeeStream stdOutStream = new TeeStream(System.out, log);
        TeeStream stdErrStream = new TeeStream(System.err, log);
        System.setOut(stdOutStream);
        System.setErr(stdErrStream);
        System.out.println("--- " + new Date().toString() + " ---");
    }

    public static void main(String[] args) {
        LoggerDeployApplication.launch((String[])args);
    }
}

