/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.websocket.server;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import us.ihmc.commons.Conversions;
import us.ihmc.pubsub.common.SerializedPayload;
import us.ihmc.robotDataLogger.VariableChangeRequest;
import us.ihmc.robotDataLogger.VariableChangeRequestPubSubType;
import us.ihmc.robotDataLogger.listeners.VariableChangedListener;
import us.ihmc.robotDataLogger.logger.LogAliveListener;
import us.ihmc.robotDataLogger.websocket.command.DataServerCommand;
import us.ihmc.robotDataLogger.websocket.server.RecyclingByteBufAllocator;
import us.ihmc.robotDataLogger.websocket.server.UDPTimestampServer;
import us.ihmc.robotDataLogger.websocket.server.WebsocketDataBroadcaster;
import us.ihmc.robotDataLogger.websocket.server.WebsocketDataServerRegistrySendStatistics;
import us.ihmc.robotDataLogger.websocket.server.WebsocketFramePool;

class WebsocketDataServerFrameHandler
extends SimpleChannelInboundHandler<WebSocketFrame> {
    private static final int BINARY_POOL_SIZE = 12;
    private static final int TEXT_POOL_SIZE = 128;
    private final WebsocketDataBroadcaster broadcaster;
    private final VariableChangedListener variableChangedListener;
    private final LogAliveListener logAliveListener;
    private final int dataSize;
    private Object lock;
    private WebsocketFramePool binaryPool;
    private WebsocketFramePool textPool = new WebsocketFramePool(DataServerCommand.MaxCommandSize(), 128, TextWebSocketFrame.class);
    private Channel channel = null;
    private RecyclingByteBufAllocator alloc = null;
    private final VariableChangeRequestPubSubType variableChangeRequestType = new VariableChangeRequestPubSubType();
    private final SerializedPayload variableChangeRequestPayload = new SerializedPayload(this.variableChangeRequestType.getTypeSize());
    private final VariableChangeRequest request = new VariableChangeRequest();
    private final UDPTimestampServer udpTimestampServer;
    private final WebsocketDataServerRegistrySendStatistics[] registryStatistics;
    private long requestedUpdateDT = 0L;

    public WebsocketDataServerFrameHandler(WebsocketDataBroadcaster broadcaster, int dataSize, int numberOfRegistryBuffers, VariableChangedListener variableChangedListener, LogAliveListener logAliveListener) throws IOException {
        this.broadcaster = broadcaster;
        this.dataSize = dataSize;
        this.variableChangedListener = variableChangedListener;
        this.logAliveListener = logAliveListener;
        this.udpTimestampServer = new UDPTimestampServer();
        this.registryStatistics = new WebsocketDataServerRegistrySendStatistics[numberOfRegistryBuffers];
        for (int i = 0; i < numberOfRegistryBuffers; ++i) {
            this.registryStatistics[i] = new WebsocketDataServerRegistrySendStatistics();
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof WebSocketServerProtocolHandler.HandshakeComplete) {
            this.lock = new Object();
            this.binaryPool = new WebsocketFramePool(this.dataSize, 12, BinaryWebSocketFrame.class);
            this.alloc = new RecyclingByteBufAllocator(ctx.alloc());
            ctx.channel().config().setAllocator((ByteBufAllocator)this.alloc);
            this.channel = ctx.channel();
            this.broadcaster.addClient(this);
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCommand(DataServerCommand command, int argument) {
        switch (command) {
            case SEND_TIMESTAMPS: {
                this.udpTimestampServer.startSending(this.remoteAddress().getAddress(), argument);
                break;
            }
            case LIMIT_RATE: {
                Object object = this.lock;
                synchronized (object) {
                    this.requestedUpdateDT = Conversions.millisecondsToNanoseconds((long)argument);
                    break;
                }
            }
            case LOG_ACTIVE: {
                if (this.logAliveListener == null) break;
                this.logAliveListener.receivedLogAliveCommand(false);
                break;
            }
            case LOG_ACTIVE_WITH_CAMERA: {
                if (this.logAliveListener == null) break;
                this.logAliveListener.receivedLogAliveCommand(true);
                break;
            }
        }
        if (command.broadcast()) {
            this.broadcaster.writeCommand(command, argument);
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, WebSocketFrame frame) throws Exception {
        try {
            if (frame instanceof TextWebSocketFrame) {
                int argument;
                DataServerCommand command = DataServerCommand.getCommand(frame.content());
                if (command != null && (argument = command.getArgument(frame.content())) != -1) {
                    this.runCommand(command, argument);
                }
            } else if (frame instanceof BinaryWebSocketFrame) {
                this.variableChangeRequestPayload.getData().clear();
                this.variableChangeRequestPayload.getData().limit(frame.content().readableBytes());
                frame.content().readBytes(this.variableChangeRequestPayload.getData());
                this.variableChangeRequestPayload.getData().flip();
                this.variableChangeRequestType.deserialize(this.variableChangeRequestPayload, this.request);
                this.variableChangedListener.changeVariable(this.request.getVariableID(), this.request.getRequestedValue());
            } else if (!(frame instanceof PingWebSocketFrame) && !(frame instanceof PongWebSocketFrame)) {
                String message = "unsupported frame type: " + frame.getClass().getName();
                throw new UnsupportedOperationException(message);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
    }

    public void addCloseFutureListener(ChannelFutureListener listener) {
        this.channel.closeFuture().addListener((GenericFutureListener)listener);
    }

    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)this.channel.remoteAddress();
    }

    Channel channel() {
        return this.channel;
    }

    private void updateRegistryStatistics(int bufferID, long timestamp) {
        if (bufferID >= this.registryStatistics.length) {
            throw new RuntimeException("Invalid registry ID");
        }
        this.registryStatistics[bufferID].update(timestamp);
    }

    private boolean shouldSend(int bufferID, long timestamp) {
        int i;
        if (this.requestedUpdateDT == 0L) {
            return true;
        }
        long fastestRegistryBufferDT = Long.MAX_VALUE;
        for (i = 0; i < this.registryStatistics.length; ++i) {
            long dt;
            if (this.registryStatistics[i].isNonMonotonic() || (dt = this.registryStatistics[i].getRegistryBufferDT()) >= fastestRegistryBufferDT) continue;
            fastestRegistryBufferDT = dt;
        }
        if (this.registryStatistics[bufferID].shouldSend(timestamp, this.requestedUpdateDT, fastestRegistryBufferDT, false)) {
            return true;
        }
        if (fastestRegistryBufferDT != Long.MAX_VALUE) {
            for (i = 0; i < this.registryStatistics.length; ++i) {
                if (this.registryStatistics[i].getRegistryBufferDT() <= this.registryStatistics[bufferID].getRegistryBufferDT() || !this.registryStatistics[i].shouldSend(timestamp, this.requestedUpdateDT, fastestRegistryBufferDT, true)) continue;
                return true;
            }
        }
        return false;
    }

    private void updateRegistrySendTimestamp(int bufferID, long timestamp) {
        this.registryStatistics[bufferID].updateSendTimestamp(timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int bufferID, long timestamp, ByteBuffer frame) {
        if (!this.channel.eventLoop().inEventLoop()) {
            throw new RuntimeException("Call this function from the channels event loop");
        }
        Object object = this.lock;
        synchronized (object) {
            this.updateRegistryStatistics(bufferID, timestamp);
            if (this.shouldSend(bufferID, timestamp)) {
                WebSocketFrame websocketFrame = this.binaryPool.createFrame(frame);
                if (websocketFrame != null && this.channel.isActive() && this.channel.isWritable()) {
                    ChannelPromise voidPromise = this.channel.voidPromise();
                    this.channel.writeAndFlush((Object)websocketFrame, voidPromise);
                }
                this.updateRegistrySendTimestamp(bufferID, timestamp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.lock;
        synchronized (object) {
            if (this.channel.isActive() || this.channel.isWritable()) {
                throw new RuntimeException("Trying to release an active channel");
            }
            this.udpTimestampServer.close();
            if (this.alloc != null) {
                this.alloc.release();
            }
            if (this.binaryPool != null) {
                this.binaryPool.release();
            }
            if (this.textPool != null) {
                this.textPool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCommand(DataServerCommand command, int argument) {
        if (!this.channel.eventLoop().inEventLoop()) {
            throw new RuntimeException("Call this function from the channels event loop");
        }
        Object object = this.lock;
        synchronized (object) {
            WebSocketFrame websocketFrame = this.textPool.createFrame();
            if (websocketFrame != null && this.channel.isActive()) {
                command.getBytes(websocketFrame.content(), argument);
                this.channel.writeAndFlush((Object)websocketFrame);
            }
        }
    }

    public void publishTimestamp(long timestamp) {
        this.udpTimestampServer.sendTimestamp(timestamp);
    }
}

