/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger;

import java.io.IOException;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;
import us.ihmc.robotDataLogger.LoggerConfiguration;

public class LoggerConfigurationPubSubType
implements TopicDataType<LoggerConfiguration> {
    public static final String name = "us::ihmc::robotDataLogger::LoggerConfiguration";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public void serialize(LoggerConfiguration data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        LoggerConfigurationPubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, LoggerConfiguration data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        LoggerConfigurationPubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return LoggerConfigurationPubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(LoggerConfiguration data) {
        return LoggerConfigurationPubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(LoggerConfiguration data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getCamerasToCapture().length() + 1;
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        return current_alignment - initial_alignment;
    }

    public static void write(LoggerConfiguration data, CDR cdr) {
        if (data.getCamerasToCapture().length() > 255) {
            throw new RuntimeException("camerasToCapture field exceeds the maximum length");
        }
        cdr.write_type_d(data.getCamerasToCapture());
        cdr.write_type_7(data.getPublicBroadcast());
    }

    public static void read(LoggerConfiguration data, CDR cdr) {
        cdr.read_type_d(data.getCamerasToCapture());
        data.setPublicBroadcast(cdr.read_type_7());
    }

    public final void serialize(LoggerConfiguration data, InterchangeSerializer ser) {
        ser.write_type_d("camerasToCapture", data.getCamerasToCapture());
        ser.write_type_7("publicBroadcast", data.getPublicBroadcast());
    }

    public final void deserialize(InterchangeSerializer ser, LoggerConfiguration data) {
        ser.read_type_d("camerasToCapture", data.getCamerasToCapture());
        data.setPublicBroadcast(ser.read_type_7("publicBroadcast"));
    }

    public static void staticCopy(LoggerConfiguration src, LoggerConfiguration dest) {
        dest.set(src);
    }

    public LoggerConfiguration createData() {
        return new LoggerConfiguration();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)LoggerConfigurationPubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(LoggerConfiguration data, CDR cdr) {
        LoggerConfigurationPubSubType.write(data, cdr);
    }

    public void deserialize(LoggerConfiguration data, CDR cdr) {
        LoggerConfigurationPubSubType.read(data, cdr);
    }

    public void copy(LoggerConfiguration src, LoggerConfiguration dest) {
        LoggerConfigurationPubSubType.staticCopy(src, dest);
    }

    public LoggerConfigurationPubSubType newInstance() {
        return new LoggerConfigurationPubSubType();
    }
}

