/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.websocket.client.discovery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import us.ihmc.log.LogTools;
import us.ihmc.robotDataLogger.interfaces.DataServerDiscoveryListener;
import us.ihmc.robotDataLogger.util.DaemonThreadFactory;
import us.ihmc.robotDataLogger.websocket.client.discovery.DataServerLocationBroadcastReceiver;
import us.ihmc.robotDataLogger.websocket.client.discovery.HTTPDataServerConnection;
import us.ihmc.robotDataLogger.websocket.client.discovery.HTTPDataServerDescription;

public class DataServerDiscoveryClient
implements DataServerLocationBroadcastReceiver.DataServerLocationFoundListener {
    private final Object lock = new Object();
    private final DataServerDiscoveryListener listener;
    private final ThreadFactory daemonThreadFactory = DaemonThreadFactory.getNamedDaemonThreadFactory(this.getClass().getSimpleName());
    private final ScheduledExecutorService connectionExecutor = Executors.newSingleThreadScheduledExecutor(this.daemonThreadFactory);
    private final Executor listenerExecutor = Executors.newSingleThreadExecutor(this.daemonThreadFactory);
    private final HashMap<HTTPDataServerDescription, HTTPDataServerDescription> hosts = new HashMap();
    private boolean clientClosed = false;
    private final HashSet<HTTPDataServerConnection> connections = new HashSet();
    private final DataServerLocationBroadcastReceiver broadcastReceiver;

    public DataServerDiscoveryClient(DataServerDiscoveryListener listener, boolean enableAutoDiscovery) {
        this.listener = listener;
        DataServerLocationBroadcastReceiver broadcastReceiver = null;
        if (enableAutoDiscovery) {
            try {
                broadcastReceiver = new DataServerLocationBroadcastReceiver(this);
                broadcastReceiver.start();
            }
            catch (IOException e) {
                LogTools.warn((String)("Cannot start broadcast receiver. " + e.getMessage()));
                broadcastReceiver = null;
            }
        }
        this.broadcastReceiver = broadcastReceiver;
    }

    public void addHosts(List<HTTPDataServerDescription> descriptions) {
        for (HTTPDataServerDescription description : descriptions) {
            this.addHost(description);
        }
    }

    @Override
    public void addHost(String host, int port, boolean persistant) {
        HTTPDataServerDescription description = new HTTPDataServerDescription(host, port, persistant);
        this.addHost(description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHost(HTTPDataServerDescription description) {
        Object object = this.lock;
        synchronized (object) {
            if (this.hosts.containsKey(description)) {
                if (description.isPersistant()) {
                    LogTools.debug((String)"{} already in list of hosts. Marking persistant", (Object)description);
                    this.hosts.put(description, description);
                } else {
                    LogTools.debug((String)"{} already in list of hosts", (Object)description);
                }
            } else {
                this.hosts.put(description, description);
                this.connectionExecutor.execute(() -> this.tryConnection(description));
            }
        }
    }

    public void close() {
        this.close(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(HTTPDataServerConnection connectionToKeep) {
        Object object = this.lock;
        synchronized (object) {
            this.clientClosed = true;
            if (connectionToKeep != null) {
                this.connections.remove(connectionToKeep);
            }
            for (HTTPDataServerConnection connection : this.connections) {
                connection.close();
            }
            if (this.broadcastReceiver != null) {
                this.broadcastReceiver.stop();
            }
        }
    }

    private void tryConnection(HTTPDataServerDescription target) {
        LogTools.debug((String)"Connecting to {}.", (Object)target);
        try {
            new HTTPDataServerConnection(target, new ConnectionListener());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<HTTPDataServerDescription> getPersistantHostList() {
        ArrayList<HTTPDataServerDescription> list = new ArrayList<HTTPDataServerDescription>();
        for (HTTPDataServerDescription description : this.hosts.values()) {
            if (!description.isPersistant()) continue;
            list.add(description);
        }
        return list;
    }

    public static void main(String[] args) {
        DataServerDiscoveryClient client = new DataServerDiscoveryClient(new DataServerDiscoveryListener(){

            @Override
            public void disconnected(HTTPDataServerConnection connection) {
                System.out.println("Disconnected from " + connection.getTarget());
            }

            @Override
            public void connected(HTTPDataServerConnection connection) {
                System.out.println("Connected " + connection.getTarget());
                connection.close();
            }
        }, true);
        client.addHost("127.0.0.1", 8008, true);
    }

    private class ConnectionListener
    implements HTTPDataServerConnection.HTTPDataServerConnectionListener {
        private ConnectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connected(HTTPDataServerConnection connection) {
            Object object = DataServerDiscoveryClient.this.lock;
            synchronized (object) {
                LogTools.debug((String)"Connected to {}.", (Object)connection.getTarget());
                DataServerDiscoveryClient.this.connections.add(connection);
                DataServerDiscoveryClient.this.listenerExecutor.execute(() -> DataServerDiscoveryClient.this.listener.connected(connection));
            }
        }

        @Override
        public void disconnected(HTTPDataServerConnection connection) {
            DataServerDiscoveryClient.this.listenerExecutor.execute(() -> DataServerDiscoveryClient.this.listener.disconnected(connection));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connectionRefused(HTTPDataServerDescription target) {
            Object object = DataServerDiscoveryClient.this.lock;
            synchronized (object) {
                LogTools.debug((String)"Connection refused to {}.", (Object)target);
                if (!DataServerDiscoveryClient.this.clientClosed && ((HTTPDataServerDescription)DataServerDiscoveryClient.this.hosts.get(target)).isPersistant()) {
                    LogTools.debug((String)"{} is marked persistant, reconnecting.", (Object)target);
                    DataServerDiscoveryClient.this.connectionExecutor.schedule(() -> DataServerDiscoveryClient.this.tryConnection(target), 1L, TimeUnit.SECONDS);
                } else {
                    LogTools.debug((String)"{} is volatile. Dropping.", (Object)target);
                    DataServerDiscoveryClient.this.hosts.remove(target);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void closed(HTTPDataServerConnection connection) {
            Object object = DataServerDiscoveryClient.this.lock;
            synchronized (object) {
                LogTools.debug((String)"Disconnected from {}.", (Object)connection.getTarget());
                DataServerDiscoveryClient.this.connections.remove(connection);
                if (!DataServerDiscoveryClient.this.clientClosed && ((HTTPDataServerDescription)DataServerDiscoveryClient.this.hosts.get(connection.getTarget())).isPersistant()) {
                    LogTools.debug((String)"{} is marked persistant, reconnecting.", (Object)connection.getTarget());
                    DataServerDiscoveryClient.this.connectionExecutor.execute(() -> DataServerDiscoveryClient.this.tryConnection(connection.getTarget()));
                } else {
                    LogTools.debug((String)"{} is volatile. Dropping.", (Object)connection.getTarget());
                    DataServerDiscoveryClient.this.hosts.remove(connection.getTarget());
                }
            }
        }
    }
}

