/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.captureVideo;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.Semaphore;
import org.freedesktop.gstreamer.Buffer;
import org.freedesktop.gstreamer.Element;
import org.freedesktop.gstreamer.Gst;
import org.freedesktop.gstreamer.Pad;
import org.freedesktop.gstreamer.PadProbeInfo;
import org.freedesktop.gstreamer.PadProbeReturn;
import org.freedesktop.gstreamer.PadProbeType;
import org.freedesktop.gstreamer.Pipeline;
import org.freedesktop.gstreamer.event.EOSEvent;
import org.freedesktop.gstreamer.event.Event;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.log.LogTools;

public class ExampleGStreamerUbuntuCapture {
    private static final Semaphore gotEOSPlayBin = new Semaphore(1);
    private static final String ubuntuGStreamer = "ubuntuGStreamer";
    public static String videoPath;
    public static String timestampPath;
    private static FileWriter timestampWriter;
    public static File videoFile;
    public static File timestampFile;

    public static void main(String[] args) throws InterruptedException, IOException {
        videoPath = "ihmc-robot-data-logger/out/ubuntuGStreamer_Video.mov";
        timestampPath = "ihmc-robot-data-logger/out/ubuntuGStreamer_Timestamps.dat";
        videoFile = new File(videoPath);
        timestampFile = new File(timestampPath);
        ExampleGStreamerUbuntuCapture.setupTimestampWriter();
        Gst.init();
        Pipeline pipeline = (Pipeline)Gst.parseLaunch((String)("decklinkvideosrc connection=sdi ! timeoverlay ! videoconvert ! videorate ! video/x-raw,framerate=60/1 ! identity name=identity ! jpegenc ! .video splitmuxsink muxer=qtmux location=" + videoFile));
        pipeline.getBus().connect(source -> {
            System.out.println("Recieved EOS on pipeline");
            gotEOSPlayBin.release();
        });
        gotEOSPlayBin.drainPermits();
        Element identity = pipeline.getElementByName("identity");
        identity.getStaticPad("sink").addProbe(PadProbeType.BUFFER, (Pad.PROBE)new TimestampProbe());
        pipeline.play();
        ThreadTools.sleepSeconds((double)10.0);
        pipeline.sendEvent((Event)new EOSEvent());
        gotEOSPlayBin.acquire(1);
        pipeline.stop();
        System.out.println("Stopped Capture");
        timestampWriter.close();
    }

    public static void setupTimestampWriter() {
        try {
            timestampWriter = new FileWriter(timestampFile);
            timestampWriter.write("1\n");
            timestampWriter.write("60000\n");
        }
        catch (IOException e) {
            LogTools.info((String)"Didn't setup the timestamp file correctly");
        }
    }

    public static void writeTimestampToFile(long controllerTimestamp, long pts) {
        try {
            timestampWriter.write(controllerTimestamp + " " + pts + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static class TimestampProbe
    implements Pad.PROBE {
        TimestampProbe() {
        }

        public PadProbeReturn probeCallback(Pad pad, PadProbeInfo info) {
            Buffer buffer = info.getBuffer();
            if (buffer.isWritable()) {
                ExampleGStreamerUbuntuCapture.writeTimestampToFile(System.nanoTime(), buffer.getPresentationTimestamp());
            }
            return PadProbeReturn.OK;
        }
    }
}

