/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.rtps;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.pubsub.Domain;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.ParticipantAttributes;
import us.ihmc.pubsub.attributes.ReliabilityKind;
import us.ihmc.pubsub.common.LogLevel;
import us.ihmc.pubsub.common.MatchingInfo;
import us.ihmc.pubsub.common.SampleInfo;
import us.ihmc.pubsub.participant.Participant;
import us.ihmc.pubsub.publisher.Publisher;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.pubsub.subscriber.SubscriberListener;
import us.ihmc.robotDataLogger.VariableChangeRequest;
import us.ihmc.robotDataLogger.VariableChangeRequestPubSubType;

public class VariableChangeRequestTest {
    @Test
    public void testReceiveChangedVariablesOneMessage() throws IOException {
        final VariableChangeRequest requestCopy = new VariableChangeRequest();
        final AtomicInteger receivedMessages = new AtomicInteger(0);
        VariableChangeRequestPubSubType type = new VariableChangeRequestPubSubType();
        SubscriberListener<Double> listener = new SubscriberListener<Double>(){
            final VariableChangeRequest request = new VariableChangeRequest();

            public void onSubscriptionMatched(Subscriber subscriber, MatchingInfo info) {
                if (info.getStatus() == MatchingInfo.MatchingStatus.MATCHED_MATCHING) {
                    System.out.println("Connected " + info.getGuid());
                } else {
                    System.out.println("Disconnected " + info.getGuid());
                }
            }

            public void onNewDataMessage(Subscriber subscriber) {
                if (subscriber.takeNextData((Object)this.request, new SampleInfo())) {
                    receivedMessages.incrementAndGet();
                    requestCopy.set(this.request);
                }
                System.out.println("Received: " + this.request);
            }
        };
        Domain domain = DomainFactory.getDomain((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS);
        Participant participant = domain.createParticipant(domain.createParticipantAttributes(1, "TestParticipant"));
        Publisher publisher = domain.createPublisher(participant, domain.createPublisherAttributes(participant, (TopicDataType)type, "testTopic", ReliabilityKind.RELIABLE.toQosKind(), new String[]{"us.ihmc"}));
        domain.createSubscriber(participant, domain.createSubscriberAttributes(participant, (TopicDataType)type, "testTopic", ReliabilityKind.RELIABLE.toQosKind(), new String[]{"us.ihmc"}), (SubscriberListener)listener);
        ThreadTools.sleep((long)1000L);
        VariableChangeRequest sentMessage = new VariableChangeRequest();
        for (int i = 0; i < 10; ++i) {
            sentMessage.variableID_ = i + 100;
            sentMessage.requestedValue_ = (double)i * 13.37;
            publisher.write((Object)sentMessage);
            System.out.println("Writing: " + sentMessage);
            ThreadTools.sleep((long)1000L);
            Assertions.assertEquals((double)sentMessage.getRequestedValue(), (double)requestCopy.getRequestedValue());
        }
        Assertions.assertEquals((int)10, (int)receivedMessages.get());
    }

    @Test
    public void testReceiveChangedVariablesMultipleMessages() throws IOException {
        final AtomicInteger receivedMessages = new AtomicInteger(0);
        VariableChangeRequestPubSubType type = new VariableChangeRequestPubSubType();
        final VariableChangeRequest requestCopy = new VariableChangeRequest();
        SubscriberListener<Double> listener = new SubscriberListener<Double>(){

            public void onSubscriptionMatched(Subscriber subscriber, MatchingInfo info) {
                if (info.getStatus() == MatchingInfo.MatchingStatus.MATCHED_MATCHING) {
                    System.out.println("Connected " + info.getGuid());
                } else {
                    System.out.println("Disconnected " + info.getGuid());
                }
            }

            public void onNewDataMessage(Subscriber subscriber) {
                VariableChangeRequest request = new VariableChangeRequest();
                SampleInfo info = new SampleInfo();
                if (subscriber.takeNextData((Object)request, info)) {
                    receivedMessages.incrementAndGet();
                    requestCopy.set(request);
                }
                System.out.println("Received: " + request);
            }
        };
        Domain domain = DomainFactory.getDomain((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS);
        domain.setLogLevel(LogLevel.WARNING);
        ParticipantAttributes attr = domain.createParticipantAttributes(1, "TestParticipant");
        attr.useOnlySharedMemoryTransport();
        Participant participant = domain.createParticipant(attr);
        Publisher publisher1 = domain.createPublisher(participant, domain.createPublisherAttributes(participant, (TopicDataType)type, "testTopic", ReliabilityKind.RELIABLE.toQosKind(), new String[]{"us/ihmc"}));
        Publisher publisher2 = domain.createPublisher(participant, domain.createPublisherAttributes(participant, (TopicDataType)type, "testTopic", ReliabilityKind.RELIABLE.toQosKind(), new String[]{"us/ihmc"}));
        Publisher publisher3 = domain.createPublisher(participant, domain.createPublisherAttributes(participant, (TopicDataType)type, "testTopic", ReliabilityKind.RELIABLE.toQosKind(), new String[]{"us/ihmc"}));
        domain.createSubscriber(participant, domain.createSubscriberAttributes(participant, (TopicDataType)type, "testTopic", ReliabilityKind.RELIABLE.toQosKind(), new String[]{"us/ihmc"}), (SubscriberListener)listener);
        ThreadTools.sleep((long)1000L);
        VariableChangeRequest messageFirst = new VariableChangeRequest();
        VariableChangeRequest messageSecond = new VariableChangeRequest();
        VariableChangeRequest messageThird = new VariableChangeRequest();
        for (int i = 0; i < 10; ++i) {
            messageFirst.setVariableID(i + 100);
            messageFirst.setRequestedValue((double)i * 1.1);
            System.out.println("Writing First: " + messageFirst);
            publisher1.write((Object)messageFirst);
            ThreadTools.sleep((long)100L);
            Assertions.assertEquals((double)messageFirst.getRequestedValue(), (double)requestCopy.getRequestedValue());
            messageSecond.setVariableID(i + 200);
            messageSecond.setRequestedValue((double)i * 2.2);
            System.out.println("Writing Second: " + messageSecond);
            publisher2.write((Object)messageSecond);
            ThreadTools.sleep((long)100L);
            Assertions.assertEquals((double)messageSecond.getRequestedValue(), (double)requestCopy.getRequestedValue());
            messageThird.setVariableID(i + 300);
            messageThird.setRequestedValue((double)i * 4.4);
            System.out.println("Writing Third: " + messageSecond);
            publisher3.write((Object)messageThird);
            ThreadTools.sleep((long)100L);
            Assertions.assertEquals((double)messageThird.getRequestedValue(), (double)requestCopy.getRequestedValue());
        }
        Assertions.assertEquals((int)30, (int)receivedMessages.get());
    }

    @Test
    public void testCheckEquals() {
        VariableChangeRequest dataOne = new VariableChangeRequest();
        for (int i = 0; i < 12; ++i) {
            dataOne.setVariableID(i + 24);
            dataOne.setRequestedValue((double)i * 3.6);
            VariableChangeRequest dataTwo = new VariableChangeRequest(dataOne);
            boolean result = dataOne.equals((Object)dataTwo);
            Assertions.assertTrue((boolean)result);
        }
    }
}

