/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.dataBuffers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.Conversions;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.RevoluteJoint;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.pubsub.common.SerializedPayload;
import us.ihmc.robotDataLogger.dataBuffers.CustomLogDataPublisherType;
import us.ihmc.robotDataLogger.dataBuffers.CustomLogDataSubscriberType;
import us.ihmc.robotDataLogger.dataBuffers.RegistryDecompressor;
import us.ihmc.robotDataLogger.dataBuffers.RegistryReceiveBuffer;
import us.ihmc.robotDataLogger.dataBuffers.RegistrySendBuffer;
import us.ihmc.robotDataLogger.dataBuffers.RegistrySendBufferBuilder;
import us.ihmc.robotDataLogger.jointState.OneDoFJointHolder;
import us.ihmc.robotDataLogger.jointState.OneDoFState;
import us.ihmc.tools.compression.CompressionImplementation;
import us.ihmc.tools.compression.CompressionImplementationFactory;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoLong;
import us.ihmc.yoVariables.variable.YoVariable;

public class RegistrySendBufferTest {
    public static final int MAX_PACKET_SIZE = 65000;

    public static int[] calculateLogSegmentSizes(int variables, int jointStates) {
        CompressionImplementation compressor = CompressionImplementationFactory.instance();
        int maxCompressedSize = compressor.maxCompressedLength(variables * 8);
        int maxSize = CustomLogDataPublisherType.getTypeSize((int)maxCompressedSize, (int)jointStates);
        if (maxSize > 65000) {
            int remaining = 65000 - CustomLogDataPublisherType.getTypeSize((int)0, (int)0);
            int totalVariables = variables + jointStates;
            int variablesPerPacket = compressor.minimumDecompressedLength(remaining) / 8;
            int packets = (totalVariables - 1) / variablesPerPacket + 1;
            int averageVariablesPerPacket = (totalVariables - 1) / packets + 1;
            int[] variableCounts = new int[packets];
            if (averageVariablesPerPacket <= jointStates) {
                variableCounts[0] = 0;
                variablesPerResultingPacket = (variables - 1) / (packets - 1) + 1;
                Arrays.fill(variableCounts, 1, variableCounts.length, variablesPerResultingPacket);
            } else {
                variableCounts[0] = averageVariablesPerPacket - jointStates;
                variablesPerResultingPacket = (variables - variableCounts[0] - 1) / (packets - 1) + 1;
                Arrays.fill(variableCounts, 1, variableCounts.length, variablesPerResultingPacket);
            }
            int sum = 0;
            for (int val : variableCounts) {
                sum += val;
            }
            int n = variableCounts.length - 1;
            variableCounts[n] = variableCounts[n] + (variables - sum);
            return variableCounts;
        }
        return new int[]{variables};
    }

    public static int[] calculateOffsets(int[] segmentSizes) {
        int[] offsets = new int[segmentSizes.length];
        int currentOffset = 0;
        for (int i = 0; i < segmentSizes.length; ++i) {
            offsets[i] = currentOffset;
            currentOffset += segmentSizes[i];
        }
        return offsets;
    }

    public static int calculateMaximumNumberOfVariables(int variables, int jointStates) {
        int[] segmentSizes = RegistrySendBufferTest.calculateLogSegmentSizes(variables, jointStates);
        int max = 0;
        for (int size : segmentSizes) {
            if (size <= max) continue;
            max = size;
        }
        return max;
    }

    @Test
    public void testYoVariables() throws IOException {
        Random random = new Random(23589735L);
        for (int numberOfVariables = 1000; numberOfVariables <= 33000; numberOfVariables += 1000) {
            ArrayList<OneDoFJointHolder> sendJointHolders = new ArrayList<OneDoFJointHolder>();
            ArrayList<OneDoFState> receiveJointStates = new ArrayList<OneDoFState>();
            RigidBody elevator = new RigidBody("elevator", ReferenceFrame.getWorldFrame());
            int numberOfJoints = random.nextInt(4000);
            for (int j = 0; j < numberOfJoints; ++j) {
                RevoluteJoint sendJoint = new RevoluteJoint("Joint" + j, (RigidBodyBasics)elevator, (Vector3DReadOnly)new Vector3D(1.0, 0.0, 0.0));
                sendJoint.setQ(random.nextDouble() * Math.PI * 2.0);
                sendJoint.setQd(random.nextDouble() * Math.PI * 2.0);
                sendJointHolders.add(new OneDoFJointHolder((OneDoFJointBasics)sendJoint));
                receiveJointStates.add(new OneDoFState("Joint" + j));
            }
            int numberOfJointStates = RegistrySendBufferBuilder.getNumberOfJointStates(sendJointHolders);
            CustomLogDataPublisherType publisherType = new CustomLogDataPublisherType(numberOfVariables, numberOfJointStates);
            SerializedPayload payload = new SerializedPayload(publisherType.getMaximumTypeSize());
            long timestamp = random.nextLong();
            long uid = random.nextLong();
            YoRegistry sendRegistry = new YoRegistry("sendRegistry");
            for (int v = 0; v < numberOfVariables; ++v) {
                YoLong newLong = new YoLong("var" + v, sendRegistry);
                newLong.set(random.nextLong());
            }
            CustomLogDataSubscriberType subscriberType = new CustomLogDataSubscriberType(RegistrySendBufferTest.calculateMaximumNumberOfVariables(numberOfVariables, numberOfJointStates), numberOfJointStates);
            YoRegistry receiveRegistry = new YoRegistry("receiveRegistry");
            for (int v = 0; v < numberOfVariables; ++v) {
                new YoLong("var" + v, receiveRegistry);
            }
            RegistryDecompressor registryDecompressor = new RegistryDecompressor(receiveRegistry.collectSubtreeVariables(), receiveJointStates);
            RegistrySendBuffer sendBuffer = new RegistrySendBuffer(1, sendRegistry.collectSubtreeVariables(), sendJointHolders);
            long start = System.nanoTime();
            sendBuffer.updateBufferFromVariables(timestamp, uid, numberOfVariables);
            System.out.println("Time taken for update if " + (numberOfVariables + numberOfJointStates) + " " + Conversions.nanosecondsToSeconds((long)(System.nanoTime() - start)));
            payload.getData().clear();
            publisherType.serialize(sendBuffer, payload);
            RegistryReceiveBuffer receiveBuffer = new RegistryReceiveBuffer(sendBuffer.getTimestamp());
            subscriberType.deserialize(payload, receiveBuffer);
            registryDecompressor.decompressSegment(receiveBuffer, 0);
            List sendVariables = sendRegistry.collectSubtreeVariables();
            List receiveVariables = receiveRegistry.collectSubtreeVariables();
            Assertions.assertEquals((int)sendVariables.size(), (int)receiveVariables.size());
            for (int t = 0; t < sendVariables.size(); ++t) {
                Assertions.assertEquals((long)((YoVariable)sendVariables.get(t)).getValueAsLongBits(), (long)((YoVariable)receiveVariables.get(t)).getValueAsLongBits());
            }
        }
    }
}

