/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.realtime.concurrent;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.concurrent.Builder;
import us.ihmc.concurrent.ConcurrentRingBuffer;

public class ConcurrentRingBufferTest {
    private int m_z = 9821271;
    private int m_w = 18917240;

    int get_random() {
        this.m_z = 36969 * (this.m_z & 0xFFFF) + (this.m_z >> 16);
        this.m_w = 18000 * (this.m_w & 0xFFFF) + (this.m_w >> 16);
        return (this.m_z << 16) + this.m_w;
    }

    @Test
    public void test() throws IOException {
        long iterations = 100000000L;
        long writesPerIteration = 1L;
        long seed = 89126450L;
        final ConcurrentRingBuffer concurrentRingBuffer = new ConcurrentRingBuffer((Builder)new MutableLongBuilder(), 1024);
        new Thread(new Runnable(){

            @Override
            public void run() {
                Random random = new Random(89126450L);
                for (long value = 0L; value < 100000000L; ++value) {
                    int y = 0;
                    while ((long)y < 1L) {
                        MutableLong nextValue;
                        while ((nextValue = (MutableLong)concurrentRingBuffer.next()) == null) {
                        }
                        nextValue.value = ConcurrentRingBufferTest.this.get_random();
                        ++y;
                    }
                    concurrentRingBuffer.commit();
                }
            }
        }).start();
        boolean running = true;
        long iteration = 0L;
        Random random = new Random(89126450L);
        int n = 5000;
        long[][] dat = new long[2][(int)(100000000L / (long)n)];
        long start = System.nanoTime();
        while (running) {
            MutableLong value;
            if (!concurrentRingBuffer.poll()) continue;
            while ((value = (MutableLong)concurrentRingBuffer.read()) != null) {
                if (iteration % (long)n == 0L) {
                    int i = (int)(iteration / (long)n);
                    dat[0][i] = System.nanoTime() - start;
                    dat[1][i] = value.value;
                }
                if (++iteration < 99999999L) continue;
                running = false;
                break;
            }
            concurrentRingBuffer.flush();
        }
        String data = "x=" + Arrays.toString(dat[0]) + ";\ny=" + Arrays.toString(dat[1]) + ";\nxi=x/1e9;\nyi=y./xi; plot(xi,yi)";
        Files.write(Paths.get("data.m", new String[0]), data.getBytes(), new OpenOption[0]);
    }

    public class MutableLongBuilder
    implements Builder<MutableLong> {
        public MutableLong newInstance() {
            return new MutableLong();
        }
    }

    private class MutableLong {
        public long value;

        private MutableLong() {
        }
    }
}

