/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.realtime.concurrent;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.concurrent.Builder;
import us.ihmc.concurrent.ConcurrentCopier;

public class ConcurrentCopierTest {
    @Test
    public void singleThreadTest() {
        long iterations = 10L;
        long seed = 890327L;
        Random random = new Random(890327L);
        ConcurrentCopier copier = new ConcurrentCopier((Builder)new MutableTestObjectBuilder());
        for (long i = 0L; i < 10L; ++i) {
            long y;
            for (y = 1L; y < 8L; ++y) {
                MutableTestObject object = (MutableTestObject)copier.getCopyForWriting();
                object.update(i * y, random.nextLong());
                copier.commit();
            }
            for (y = 0L; y < 4L; ++y) {
                MutableTestObject readObject = (MutableTestObject)copier.getCopyForReading();
                readObject.test();
            }
        }
    }

    @Test
    public void test() {
        long iterations = 1000000L;
        long seed = 89126450L;
        final ConcurrentCopier copier = new ConcurrentCopier((Builder)new MutableTestObjectBuilder());
        new Thread(new Runnable(){

            @Override
            public void run() {
                Random random = new Random(89126450L);
                for (long value = 0L; value < 1000000L; ++value) {
                    MutableTestObject next = (MutableTestObject)copier.getCopyForWriting();
                    next.update(value, random.nextLong());
                    copier.commit();
                }
            }
        }).start();
        while (true) {
            MutableTestObject mutableTestObject;
            if ((mutableTestObject = (MutableTestObject)copier.getCopyForReading()) == null) {
                continue;
            }
            mutableTestObject.test();
            if (mutableTestObject.iteration >= 999999L) break;
        }
    }

    public class MutableTestObjectBuilder
    implements Builder<MutableTestObject> {
        public MutableTestObject newInstance() {
            return new MutableTestObject();
        }
    }

    private class MutableTestObject {
        public long iteration;
        public long seed;
        public double[] values = new double[100];

        private MutableTestObject() {
        }

        public void update(long iteration, long seed) {
            this.iteration = iteration;
            this.seed = seed;
            Random random = new Random(seed);
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = random.nextDouble();
            }
        }

        public void test() {
            Random random = new Random(this.seed);
            for (int i = 0; i < this.values.length; ++i) {
                Assertions.assertEquals((double)this.values[i], (double)random.nextDouble(), (double)1.0E-12);
            }
        }
    }
}

