/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.realtime;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.realtime.MonotonicTime;

public class MonotonicTimeTest {
    public static final long NANOSECONDS_PER_SECOND = 1000000000L;

    private void normalize(long seconds, long nanoseconds) {
        while (nanoseconds >= 1000000000L) {
            nanoseconds -= 1000000000L;
            ++seconds;
        }
        while (nanoseconds < 0L) {
            nanoseconds += 1000000000L;
            --seconds;
        }
    }

    @Test
    public void testNormalize() {
        Random random = new Random(151857L);
        MonotonicTime time = new MonotonicTime();
        for (int i = 0; i < 10; ++i) {
            long seconds = random.nextInt(0x40000000);
            long nanoseconds = Math.abs(random.nextLong());
            time.set(seconds, nanoseconds);
            while (nanoseconds >= 1000000000L) {
                nanoseconds -= 1000000000L;
                ++seconds;
            }
            while (nanoseconds < 0L) {
                nanoseconds += 1000000000L;
                --seconds;
            }
            Assertions.assertEquals((long)seconds, (long)time.seconds());
            Assertions.assertEquals((long)nanoseconds, (long)time.nanoseconds());
        }
    }
}

