/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.attributes;

import com.eprosima.xmlschemas.fastrtps_profiles.DataWriterQosPoliciesType;
import com.eprosima.xmlschemas.fastrtps_profiles.LifespanQosPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.PartitionQosPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.ProfilesType;
import com.eprosima.xmlschemas.fastrtps_profiles.PublishModeQosKindPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.PublishModeQosPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.PublisherProfileType;
import com.eprosima.xmlschemas.fastrtps_profiles.WriterTimesType;
import java.io.IOException;
import us.ihmc.pubsub.attributes.CommonAttributes;
import us.ihmc.pubsub.attributes.DDSConversionTools;
import us.ihmc.pubsub.common.Time;
import us.ihmc.pubsub.impl.fastRTPS.FastRTPSDomain;

public class PublisherAttributes
extends CommonAttributes<PublisherAttributes> {
    private final PublisherProfileType publisherProfile = new PublisherProfileType();

    public PublisherAttributes() {
        DataWriterQosPoliciesType dataWriterQosPoliciesType = new DataWriterQosPoliciesType();
        dataWriterQosPoliciesType.setDurability(this.durabilityQosPolicyType);
        dataWriterQosPoliciesType.setReliability(this.reliabilityQosPolicyType);
        this.publisherProfile.setQos(dataWriterQosPoliciesType);
        this.publisherProfile.setTopic(this.topicElementType);
    }

    public static PublisherAttributes create() {
        return new PublisherAttributes();
    }

    public PublisherProfileType getProfile() {
        return this.publisherProfile;
    }

    public PublisherAttributes publishModeKind(PublishModeQosKindPolicyType kind) {
        PublishModeQosPolicyType publishModeQosPolicyType = new PublishModeQosPolicyType();
        publishModeQosPolicyType.setKind(kind);
        this.publisherProfile.getQos().setPublishMode(publishModeQosPolicyType);
        return this;
    }

    public PublisherAttributes userDefinedId(short id) {
        this.publisherProfile.setUserDefinedID(id);
        return this;
    }

    public short getUserDefinedId() {
        return this.publisherProfile.getUserDefinedID();
    }

    public PublisherAttributes heartBeatPeriod(Time hearbeat) {
        if (this.publisherProfile.getTimes() == null) {
            this.publisherProfile.setTimes(new WriterTimesType());
        }
        this.publisherProfile.getTimes().setHeartbeatPeriod(DDSConversionTools.timeToDurationType(hearbeat));
        return this;
    }

    public String marshall(String profileName) throws IOException {
        this.publisherProfile.setProfileName(profileName);
        ProfilesType profilesType = new ProfilesType();
        profilesType.getDomainparticipantFactoryOrParticipantOrDataWriter().add(this.publisherProfile);
        return FastRTPSDomain.marshalProfile(profilesType);
    }

    @Override
    protected void setPartitionQosPolicyType(PartitionQosPolicyType partitionQosPolicyType) {
        this.publisherProfile.getQos().setPartition(partitionQosPolicyType);
    }

    @Override
    protected PartitionQosPolicyType getPartitionQosPolicyType() {
        return this.publisherProfile.getQos().getPartition();
    }

    @Override
    protected void setLifespanQosPolicyType(LifespanQosPolicyType lifespanQosPolicyType) {
        this.publisherProfile.getQos().setLifespan(lifespanQosPolicyType);
    }

    @Override
    protected LifespanQosPolicyType getLifespanQosPolicyType() {
        return this.publisherProfile.getQos().getLifespan();
    }
}

