/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.impl.intraprocess;

import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.SubscriberAttributes;
import us.ihmc.pubsub.common.Guid;
import us.ihmc.pubsub.common.MatchingInfo;
import us.ihmc.pubsub.common.SampleInfo;
import us.ihmc.pubsub.impl.intraprocess.IntraProcessDomainImpl;
import us.ihmc.pubsub.impl.intraprocess.IntraProcessParticipant;
import us.ihmc.pubsub.impl.intraprocess.IntraProcessPublisher;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.pubsub.subscriber.SubscriberListener;

class IntraProcessSubscriber<T>
implements Subscriber<T> {
    private final ReentrantLock messageLock = new ReentrantLock();
    private final Condition messageCondition = this.messageLock.newCondition();
    private final TopicDataType<T> topicDataType;
    private final Guid guid;
    private final SubscriberAttributes attr;
    private IntraProcessParticipant participant;
    private SubscriberListener<T> listener;
    private final LinkedList<MessageHolder> messageQueue;
    private boolean hasMatched = false;
    private boolean available = true;
    private boolean isRemoved = false;
    private long numberOfReceivedMessages = 0L;

    IntraProcessSubscriber(Guid guid, IntraProcessDomainImpl domain, IntraProcessParticipant intraProcessParticipant, SubscriberAttributes attr, SubscriberListener<T> listener) throws IOException {
        TopicDataType<?> topicDataType = intraProcessParticipant.getTopicDataType(attr.getTopicDataType().getName());
        if (topicDataType == null) {
            throw new IOException("Cannot registered publisher with topic " + attr.getTopicDataType() + ". Topic data type is not registered.");
        }
        this.topicDataType = topicDataType.newInstance();
        this.guid = guid;
        this.participant = intraProcessParticipant;
        this.attr = attr;
        this.listener = listener;
        this.messageQueue = new LinkedList();
    }

    @Override
    public Guid getGuid() {
        return this.guid;
    }

    @Override
    public void waitForUnreadMessage(int timeoutInMilliseconds) throws InterruptedException {
        this.messageLock.lock();
        if (this.messageQueue.peek() == null) {
            if (timeoutInMilliseconds > 0) {
                this.messageCondition.await(timeoutInMilliseconds, TimeUnit.MILLISECONDS);
            } else {
                this.messageCondition.await();
            }
        }
        this.messageLock.unlock();
    }

    @Override
    public boolean readNextData(T data, SampleInfo info) {
        this.messageLock.lock();
        MessageHolder next = this.messageQueue.peek();
        if (next != null) {
            this.topicDataType.copy(next.message, data);
            if (info != null) {
                info.set(next.info);
            }
            this.messageLock.unlock();
            ++this.numberOfReceivedMessages;
            return true;
        }
        this.messageLock.unlock();
        return false;
    }

    @Override
    public T readNextData() {
        return this.readNextData(null);
    }

    @Override
    public T readNextData(SampleInfo info) {
        T nextData = this.topicDataType.createData();
        if (this.readNextData(nextData, info)) {
            return nextData;
        }
        return null;
    }

    @Override
    public boolean takeNextData(T data, SampleInfo info) {
        this.messageLock.lock();
        MessageHolder next = this.messageQueue.poll();
        if (next != null) {
            this.topicDataType.copy(next.message, data);
            if (info != null) {
                info.set(next.info);
            }
            this.messageLock.unlock();
            ++this.numberOfReceivedMessages;
            return true;
        }
        this.messageLock.unlock();
        return false;
    }

    @Override
    public T takeNextData() {
        return this.takeNextData(null);
    }

    @Override
    public T takeNextData(SampleInfo info) {
        T nextData = this.topicDataType.createData();
        if (this.takeNextData(nextData, info)) {
            return nextData;
        }
        return null;
    }

    @Override
    public SubscriberAttributes getAttributes() {
        return this.attr;
    }

    @Override
    public boolean isInCleanState() {
        return true;
    }

    @Override
    public boolean hasMatched() {
        return this.hasMatched;
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    public void notifySubscriberListener(IntraProcessPublisher<T> publisher, MatchingInfo.MatchingStatus matchedMatching) {
        if (this.listener != null) {
            MatchingInfo info = new MatchingInfo();
            info.setStatus(matchedMatching);
            info.getGuid().set(publisher.getGuid());
            this.listener.onSubscriptionMatched(this, info);
            this.hasMatched = true;
        }
    }

    public IntraProcessParticipant getParticipant() {
        return this.participant;
    }

    void destroy() {
        this.available = false;
        this.isRemoved = true;
        this.participant = null;
        this.listener = null;
        this.messageQueue.clear();
    }

    void putNextData(Object newData, SampleInfo newInfo) {
        this.messageLock.lock();
        this.messageQueue.offer(new MessageHolder(newData, newInfo));
        this.messageCondition.signal();
        this.messageLock.unlock();
        if (this.listener != null) {
            this.listener.onNewDataMessage(this);
        }
    }

    @Override
    public boolean isRemoved() {
        return this.isRemoved;
    }

    @Override
    public long getNumberOfReceivedMessages() {
        return this.numberOfReceivedMessages;
    }

    @Override
    public long getCurrentMessageSize() {
        return 0L;
    }

    @Override
    public long getLargestMessageSize() {
        return 0L;
    }

    @Override
    public long getCumulativePayloadBytes() {
        return 0L;
    }

    private class MessageHolder {
        T message;
        SampleInfo info;

        public MessageHolder(Object newData, SampleInfo newInfo) {
            this.message = newData;
            this.info = newInfo;
        }
    }
}

