/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.impl.intraprocess;

import com.eprosima.xmlschemas.fastrtps_profiles.TopicKindType;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.ParticipantAttributes;
import us.ihmc.pubsub.attributes.PublisherAttributes;
import us.ihmc.pubsub.attributes.SubscriberAttributes;
import us.ihmc.pubsub.common.DiscoveryStatus;
import us.ihmc.pubsub.common.Guid;
import us.ihmc.pubsub.impl.intraprocess.IntraProcessDomainImpl;
import us.ihmc.pubsub.impl.intraprocess.IntraProcessPublisher;
import us.ihmc.pubsub.impl.intraprocess.IntraProcessSubscriber;
import us.ihmc.pubsub.participant.Participant;
import us.ihmc.pubsub.participant.ParticipantDiscoveryInfo;
import us.ihmc.pubsub.participant.ParticipantListener;
import us.ihmc.pubsub.participant.PublisherEndpointDiscoveryListener;
import us.ihmc.pubsub.participant.SubscriberEndpointDiscoveryListener;
import us.ihmc.pubsub.publisher.Publisher;
import us.ihmc.pubsub.publisher.PublisherListener;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.pubsub.subscriber.SubscriberListener;

public class IntraProcessParticipant
implements Participant {
    private final ParticipantAttributes attributes;
    private final Guid guid = new Guid();
    private boolean isAvailable = true;
    private boolean isRemoved = true;
    private int entityId = 0;
    private IntraProcessDomainImpl domain;
    private ParticipantListener participantListener;
    private PublisherEndpointDiscoveryListener publisherEndpointDiscoveryListener = null;
    private SubscriberEndpointDiscoveryListener subscriberEndpointDiscoveryListener = null;
    private final ArrayList<IntraProcessSubscriber> subscribers = new ArrayList();
    private final ArrayList<IntraProcessPublisher> publishers = new ArrayList();
    private final ArrayList<Publisher> allPublishersForStatistics = new ArrayList();
    private final ArrayList<Subscriber<?>> allSubscribersForStatistics = new ArrayList();
    private final HashMap<String, TopicDataType<?>> registeredTopicDataTypes = new HashMap();

    IntraProcessParticipant(IntraProcessDomainImpl domain, ParticipantAttributes att, ParticipantListener participantListener) {
        this.attributes = att;
        this.participantListener = participantListener;
        this.domain = domain;
        byte[] guidBytes = new byte[12];
        Random random = new Random();
        random.nextBytes(guidBytes);
        this.guid.getGuidPrefix().setValue(guidBytes);
    }

    IntraProcessDomainImpl getDomain() {
        return this.domain;
    }

    String getName() {
        return this.attributes.getName();
    }

    @Override
    public Guid getGuid() {
        return this.guid;
    }

    @Override
    public ParticipantAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public void registerEndpointDiscoveryListeners(PublisherEndpointDiscoveryListener publisherEndpointDiscoveryListener, SubscriberEndpointDiscoveryListener subscriberEndpointDiscoveryListener) throws IOException {
        this.subscriberEndpointDiscoveryListener = subscriberEndpointDiscoveryListener;
        this.publisherEndpointDiscoveryListener = publisherEndpointDiscoveryListener;
    }

    @Override
    public int get_no_publisher(String target_topic) {
        int size = 0;
        for (IntraProcessPublisher publisher : this.publishers) {
            if (!publisher.getAttributes().getTopicName().equals(target_topic)) continue;
            ++size;
        }
        return size;
    }

    @Override
    public int get_no_subscribers(String target_topic) {
        int size = 0;
        for (IntraProcessSubscriber subscriber : this.subscribers) {
            if (!subscriber.getAttributes().getTopicName().equals(target_topic)) continue;
            ++size;
        }
        return size;
    }

    @Override
    public boolean isAvailable() {
        return this.isAvailable;
    }

    @Override
    public boolean isRemoved() {
        return this.isRemoved;
    }

    private Guid createNextGuid() {
        ++this.entityId;
        Guid child = new Guid();
        child.getGuidPrefix().setValue(this.guid.getGuidPrefix().getValue());
        child.getEntity().setValue(ByteBuffer.allocate(4).putInt(this.entityId).array());
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IntraProcessPublisher createPublisher(IntraProcessDomainImpl domain, PublisherAttributes attr, PublisherListener listener) throws IOException {
        IntraProcessPublisher publisher = new IntraProcessPublisher(this.createNextGuid(), domain, this, attr, listener);
        this.publishers.add(publisher);
        ArrayList<Publisher> arrayList = this.allPublishersForStatistics;
        synchronized (arrayList) {
            this.allPublishersForStatistics.add(publisher);
        }
        return publisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IntraProcessSubscriber createSubscriber(IntraProcessDomainImpl domain, SubscriberAttributes attr, SubscriberListener listener) throws IOException {
        IntraProcessSubscriber subscriber = new IntraProcessSubscriber(this.createNextGuid(), domain, this, attr, listener);
        this.subscribers.add(subscriber);
        ArrayList<Subscriber<?>> arrayList = this.allSubscribersForStatistics;
        synchronized (arrayList) {
            this.allSubscribersForStatistics.add(subscriber);
        }
        return subscriber;
    }

    void notifyParticipantListener(IntraProcessParticipant participant, DiscoveryStatus discoveryStatus) {
        if (this.participantListener != null) {
            ParticipantDiscoveryInfo info = new ParticipantDiscoveryInfo(participant.getName(), participant.getGuid(), discoveryStatus);
            this.participantListener.onParticipantDiscovery(participant, info);
        }
    }

    void notifySubscriberDiscoveryListener(IntraProcessSubscriber subscriber) {
        if (this.subscriberEndpointDiscoveryListener != null) {
            this.subscriberEndpointDiscoveryListener.subscriberTopicChange(true, subscriber.getGuid(), false, subscriber.getParticipant().getGuid(), subscriber.getAttributes().getTopicDataType().getName(), subscriber.getAttributes().getTopicName(), -1, TopicKindType.NO_KEY);
        }
    }

    void notifyPublisherDiscoveryListener(IntraProcessPublisher publisher) {
        if (this.publisherEndpointDiscoveryListener != null) {
            this.publisherEndpointDiscoveryListener.publisherTopicChange(true, publisher.getGuid(), publisher.getParticipant().getGuid(), publisher.getAttributes().getTopicDataType().getName(), publisher.getAttributes().getTopicName(), -1, publisher.getTopicDataType().getTypeSize(), TopicKindType.NO_KEY);
        }
    }

    TopicDataType<?> getTopicDataType(String topicDataType) {
        return this.registeredTopicDataTypes.get(topicDataType);
    }

    void registerTopicDataType(TopicDataType<?> type) {
        this.registeredTopicDataTypes.put(type.getName(), type);
    }

    public void unRegisterTopicDataType(String typeName) throws IOException {
        if (this.registeredTopicDataTypes.remove(typeName) == null) {
            throw new IOException("Cannot remove " + typeName + " from participant " + this.getName() + ". Type not registered");
        }
    }

    List<IntraProcessSubscriber> getSubscribers() {
        return new ArrayList<IntraProcessSubscriber>(this.subscribers);
    }

    List<IntraProcessPublisher> getPublishers() {
        return new ArrayList<IntraProcessPublisher>(this.publishers);
    }

    void unregister(IntraProcessSubscriber subscriber) {
        this.subscribers.remove(subscriber);
    }

    void unregister(IntraProcessPublisher publisher) {
        this.publishers.remove(publisher);
    }

    void destroy() {
        this.isAvailable = false;
        this.isRemoved = true;
        this.domain = null;
        this.participantListener = null;
        this.publisherEndpointDiscoveryListener = null;
        this.subscriberEndpointDiscoveryListener = null;
        this.registeredTopicDataTypes.clear();
    }

    public ArrayList<Publisher> getAllPublishersForStatistics() {
        return this.allPublishersForStatistics;
    }

    public ArrayList<Subscriber<?>> getAllSubscribersForStatistics() {
        return this.allSubscribersForStatistics;
    }
}

