/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub;

import com.eprosima.xmlschemas.fastrtps_profiles.ReliabilityQosKindType;
import com.eprosima.xmlschemas.fastrtps_profiles.TopicKindType;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.ParticipantAttributes;
import us.ihmc.pubsub.attributes.PublisherAttributes;
import us.ihmc.pubsub.attributes.SubscriberAttributes;
import us.ihmc.pubsub.common.LogLevel;
import us.ihmc.pubsub.common.Time;
import us.ihmc.pubsub.participant.Participant;
import us.ihmc.pubsub.participant.ParticipantListener;
import us.ihmc.pubsub.publisher.Publisher;
import us.ihmc.pubsub.publisher.PublisherListener;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.pubsub.subscriber.SubscriberListener;

public interface Domain {
    public void setLogLevel(LogLevel var1);

    public Participant createParticipant(ParticipantAttributes var1, ParticipantListener var2) throws IOException;

    default public Participant createParticipant(ParticipantAttributes att) throws IOException {
        return this.createParticipant(att, null);
    }

    public Publisher createPublisherImpl(Participant var1, PublisherAttributes var2, PublisherListener var3) throws IOException, IllegalArgumentException;

    default public Publisher createPublisher(Participant participant, PublisherAttributes publisherAttributes, PublisherListener listener) throws IOException, IllegalArgumentException {
        TopicDataType<?> registeredType = this.getRegisteredType(participant, publisherAttributes.getTopicDataType().getName());
        if (registeredType == null) {
            this.registerType(participant, publisherAttributes.getTopicDataType());
        }
        return this.createPublisherImpl(participant, publisherAttributes, listener);
    }

    default public Publisher createPublisher(Participant participant, PublisherAttributes publisherAttributes) throws IOException, IllegalArgumentException {
        return this.createPublisher(participant, publisherAttributes, null);
    }

    public Subscriber createSubscriberImpl(Participant var1, SubscriberAttributes var2, SubscriberListener var3) throws IOException, IllegalArgumentException;

    default public Subscriber createSubscriber(Participant participant, SubscriberAttributes subscriberAttributes, SubscriberListener listener) throws IOException, IllegalArgumentException {
        TopicDataType<?> registeredType = this.getRegisteredType(participant, subscriberAttributes.getTopicDataType().getName());
        if (registeredType == null) {
            this.registerType(participant, subscriberAttributes.getTopicDataType());
        }
        return this.createSubscriberImpl(participant, subscriberAttributes, listener);
    }

    default public Subscriber createSubscriber(Participant participant, SubscriberAttributes subscriberAttributes) throws IOException, IllegalArgumentException {
        return this.createSubscriberImpl(participant, subscriberAttributes, null);
    }

    public boolean removeParticipant(Participant var1);

    public boolean removePublisher(Publisher var1);

    public boolean removeSubscriber(Subscriber var1);

    public TopicDataType<?> getRegisteredType(Participant var1, String var2);

    public void registerType(Participant var1, TopicDataType<?> var2) throws IllegalArgumentException;

    public void unregisterType(Participant var1, String var2) throws IOException;

    public void stopAll();

    default public ParticipantAttributes createParticipantAttributes(int domainId, String name) {
        ParticipantAttributes attrs = ParticipantAttributes.create().domainId(domainId).discoveryLeaseDuration(Time.Infinite).name(name);
        return attrs;
    }

    default public SubscriberAttributes createSubscriberAttributes(Participant participant, TopicDataType<?> topicDataType, String topicName, ReliabilityQosKindType reliabilityKind, String ... partitions) {
        TopicDataType<?> registeredType = this.getRegisteredType(participant, topicDataType.getName());
        if (registeredType == null) {
            this.registerType(participant, topicDataType);
        }
        SubscriberAttributes subscriberAttributes = (SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)SubscriberAttributes.create().topicKind(topicDataType.isGetKeyDefined() ? TopicKindType.WITH_KEY : TopicKindType.NO_KEY)).topicDataType(topicDataType)).topicName(topicName)).reliabilityKind(reliabilityKind);
        if (partitions != null) {
            subscriberAttributes.partitions(Arrays.asList(partitions));
        }
        return subscriberAttributes;
    }

    default public PublisherAttributes createPublisherAttributes(Participant participant, TopicDataType<?> topicDataType, String topicName, ReliabilityQosKindType reliabilityKind, String ... partitions) {
        TopicDataType<?> registeredType = this.getRegisteredType(participant, topicDataType.getName());
        if (registeredType == null) {
            this.registerType(participant, topicDataType);
        }
        PublisherAttributes publisherAttributes = (PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)PublisherAttributes.create().topicKind(topicDataType.isGetKeyDefined() ? TopicKindType.WITH_KEY : TopicKindType.NO_KEY)).topicDataType(topicDataType)).topicName(topicName)).reliabilityKind(reliabilityKind);
        if (partitions != null) {
            publisherAttributes.partitions(Arrays.asList(partitions));
        }
        return publisherAttributes;
    }

    public List<Participant> getAllParticipantsForStatistics();
}

