/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.impl.intraprocess;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import us.ihmc.pubsub.Domain;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.ParticipantAttributes;
import us.ihmc.pubsub.attributes.PublisherAttributes;
import us.ihmc.pubsub.attributes.SubscriberAttributes;
import us.ihmc.pubsub.common.LogLevel;
import us.ihmc.pubsub.impl.intraprocess.IntraProcessDomainImpl;
import us.ihmc.pubsub.impl.intraprocess.IntraProcessParticipant;
import us.ihmc.pubsub.impl.intraprocess.IntraProcessPublisher;
import us.ihmc.pubsub.impl.intraprocess.IntraProcessSubscriber;
import us.ihmc.pubsub.participant.Participant;
import us.ihmc.pubsub.participant.ParticipantListener;
import us.ihmc.pubsub.publisher.Publisher;
import us.ihmc.pubsub.publisher.PublisherListener;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.pubsub.subscriber.SubscriberListener;

public class IntraProcessDomain
implements Domain {
    private LogLevel logLevel = LogLevel.WARNING;
    private static IntraProcessDomain instance = null;
    private final IntraProcessDomainImpl[] domains = new IntraProcessDomainImpl[233];
    private final HashMap<Participant, IntraProcessParticipant> participants = new HashMap();
    private final ArrayList<Participant> allParticipantsForStatistics = new ArrayList();

    public static synchronized IntraProcessDomain getInstance() {
        if (instance == null) {
            instance = new IntraProcessDomain();
        }
        return instance;
    }

    private IntraProcessDomain() {
    }

    @Override
    public void setLogLevel(LogLevel level) {
        this.logLevel = level;
    }

    private synchronized IntraProcessDomainImpl getOrCreateDomain(int domainId) throws IOException {
        if (domainId < 0 || domainId > 232) {
            throw new IOException("Invalid domain id. Valid range for domain id is0 - 232");
        }
        if (this.domains[domainId] == null) {
            this.domains[domainId] = new IntraProcessDomainImpl(domainId, this.logLevel);
        }
        return this.domains[domainId];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Participant createParticipant(ParticipantAttributes att, ParticipantListener participantListener) throws IOException {
        IntraProcessDomainImpl domain = this.getOrCreateDomain(att.getDomainId());
        IntraProcessParticipant participant = domain.createParticipant(att, participantListener);
        this.participants.put(participant, participant);
        ArrayList<Participant> arrayList = this.allParticipantsForStatistics;
        synchronized (arrayList) {
            this.allParticipantsForStatistics.add(participant);
        }
        return participant;
    }

    @Override
    public synchronized Publisher createPublisherImpl(Participant participant, PublisherAttributes publisherAttributes, PublisherListener listener) throws IOException, IllegalArgumentException {
        if (!(publisherAttributes instanceof PublisherAttributes)) {
            throw new IllegalArgumentException("Attributes not instance of CommonPublisherAttributes");
        }
        PublisherAttributes typedAttrs = publisherAttributes;
        IntraProcessParticipant intraProcessParticipant = this.participants.get(participant);
        if (intraProcessParticipant == null) {
            throw new IllegalArgumentException("This participant is not registered with this domain.");
        }
        return intraProcessParticipant.getDomain().createPublisher(intraProcessParticipant, typedAttrs, listener);
    }

    @Override
    public synchronized Subscriber createSubscriberImpl(Participant participant, SubscriberAttributes subscriberAttributes, SubscriberListener listener) throws IOException, IllegalArgumentException {
        IntraProcessParticipant intraProcessParticipant = this.participants.get(participant);
        if (intraProcessParticipant == null) {
            throw new IllegalArgumentException("This participant is not registered with this domain.");
        }
        return intraProcessParticipant.getDomain().createSubscriber(intraProcessParticipant, subscriberAttributes, listener);
    }

    @Override
    public synchronized boolean removeParticipant(Participant participant) {
        IntraProcessParticipant intraProcessParticipant = this.participants.get(participant);
        if (intraProcessParticipant == null) {
            throw new IllegalArgumentException("This participant is not registered with this domain.");
        }
        if (intraProcessParticipant.getDomain().removeParticipant(intraProcessParticipant)) {
            this.participants.remove(participant);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean removePublisher(Publisher publisher) {
        if (publisher instanceof IntraProcessPublisher) {
            IntraProcessPublisher intraProcessPublisher = (IntraProcessPublisher)publisher;
            return intraProcessPublisher.getParticipant().getDomain().removePublisher(intraProcessPublisher);
        }
        throw new RuntimeException("Publisher is not of type IntraProcessPublisher");
    }

    @Override
    public synchronized boolean removeSubscriber(Subscriber subscriber) {
        if (subscriber instanceof IntraProcessSubscriber) {
            IntraProcessSubscriber intraProcessSubscriber = (IntraProcessSubscriber)subscriber;
            return intraProcessSubscriber.getParticipant().getDomain().removeSubscriber(intraProcessSubscriber);
        }
        throw new RuntimeException("Subscriber is not of type IntraProcessSubscriber");
    }

    @Override
    public TopicDataType<?> getRegisteredType(Participant participant, String typeName) {
        IntraProcessParticipant intraProcessParticipant = this.participants.get(participant);
        if (intraProcessParticipant == null) {
            throw new IllegalArgumentException("This participant is not registered with this domain.");
        }
        return intraProcessParticipant.getTopicDataType(typeName);
    }

    @Override
    public synchronized void registerType(Participant participant, TopicDataType<?> topicDataType) throws IllegalArgumentException {
        IntraProcessParticipant intraProcessParticipant = this.participants.get(participant);
        if (intraProcessParticipant == null) {
            throw new IllegalArgumentException("This participant is not registered with this domain.");
        }
        intraProcessParticipant.registerTopicDataType(topicDataType);
    }

    @Override
    public synchronized void unregisterType(Participant participant, String typeName) throws IOException {
        IntraProcessParticipant intraProcessParticipant = this.participants.get(participant);
        if (intraProcessParticipant == null) {
            throw new IllegalArgumentException("This participant is not registered with this domain.");
        }
        intraProcessParticipant.unRegisterTopicDataType(typeName);
    }

    @Override
    public synchronized void stopAll() {
        ArrayList<IntraProcessParticipant> participantsToRemove = new ArrayList<IntraProcessParticipant>(this.participants.values());
        for (IntraProcessParticipant participantToRemove : participantsToRemove) {
            this.removeParticipant(participantToRemove);
        }
    }

    @Override
    public List<Participant> getAllParticipantsForStatistics() {
        return this.allParticipantsForStatistics;
    }
}

