/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.attributes;

import com.eprosima.xmlschemas.fastrtps_profiles.LifespanQosPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.PartitionQosPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.ProfilesType;
import com.eprosima.xmlschemas.fastrtps_profiles.PublishModeQosKindType;
import com.eprosima.xmlschemas.fastrtps_profiles.PublishModeQosPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.PublisherProfileType;
import com.eprosima.xmlschemas.fastrtps_profiles.WriterQosPoliciesType;
import com.eprosima.xmlschemas.fastrtps_profiles.WriterTimesType;
import java.io.IOException;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import us.ihmc.pubsub.attributes.CommonAttributes;
import us.ihmc.pubsub.attributes.DDSConversionTools;
import us.ihmc.pubsub.common.Time;
import us.ihmc.pubsub.impl.fastRTPS.FastRTPSDomain;

public class PublisherAttributes
extends CommonAttributes<PublisherAttributes> {
    private final PublisherProfileType publisherProfile = new PublisherProfileType();

    public PublisherAttributes() {
        this.publisherProfile.setTopic(this.topicAttributesType);
        WriterQosPoliciesType writerQosPoliciesType = new WriterQosPoliciesType();
        writerQosPoliciesType.setDurability(this.durabilityQosPolicyType);
        writerQosPoliciesType.setReliability(this.reliabilityQosPolicyType);
        this.publisherProfile.setQos(writerQosPoliciesType);
    }

    public static PublisherAttributes create() {
        return new PublisherAttributes();
    }

    public PublisherProfileType getProfile() {
        return this.publisherProfile;
    }

    public PublisherAttributes publishModeKind(PublishModeQosKindType kind) {
        PublishModeQosPolicyType publishModeQosPolicyType = new PublishModeQosPolicyType();
        publishModeQosPolicyType.setKind(kind);
        this.publisherProfile.getQos().setPublishMode(publishModeQosPolicyType);
        return this;
    }

    public PublisherAttributes userDefinedId(short id) {
        this.publisherProfile.setUserDefinedID(id);
        return this;
    }

    public short getUserDefinedId() {
        return this.publisherProfile.getUserDefinedID();
    }

    public PublisherAttributes heartBeatPeriod(Time hearbeat) {
        if (this.publisherProfile.getTimes() == null) {
            this.publisherProfile.setTimes(new WriterTimesType());
        }
        this.publisherProfile.getTimes().setHeartbeatPeriod(DDSConversionTools.timeToDurationType(hearbeat));
        return this;
    }

    public String marshall(String profileName) throws IOException {
        ProfilesType profilesType = new ProfilesType();
        profilesType.getLibrarySettingsOrTransportDescriptorsOrParticipant().add(new JAXBElement(new QName("http://www.eprosima.com/XMLSchemas/fastRTPS_Profiles", "publisher"), PublisherProfileType.class, (Object)this.publisherProfile));
        this.publisherProfile.setProfileName(profileName);
        return FastRTPSDomain.marshalProfile(profilesType);
    }

    @Override
    protected void setPartitionQosPolicyType(PartitionQosPolicyType partitionQosPolicyType) {
        this.publisherProfile.getQos().setPartition(partitionQosPolicyType);
    }

    @Override
    protected PartitionQosPolicyType getPartitionQosPolicyType() {
        return this.publisherProfile.getQos().getPartition();
    }

    @Override
    protected void setLifespanQosPolicyType(LifespanQosPolicyType lifespanQosPolicyType) {
        this.publisherProfile.getQos().setLifespan(lifespanQosPolicyType);
    }

    @Override
    protected LifespanQosPolicyType getLifespanQosPolicyType() {
        return this.publisherProfile.getQos().getLifespan();
    }
}

