/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.idl;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.idl.IDLSequence;
import us.ihmc.idl.IDLTools;

public class IDLToolsTest {
    @Test
    public void testStringBuilderEquals() {
        Assertions.assertTrue((boolean)IDLTools.equals((StringBuilder)new StringBuilder("hi"), (StringBuilder)new StringBuilder("hi")), (String)"StringBuilders not equal");
        Assertions.assertTrue((boolean)IDLTools.equals((StringBuilder)new StringBuilder("a"), (StringBuilder)new StringBuilder("a")), (String)"StringBuilders not equal");
        Assertions.assertFalse((boolean)IDLTools.equals((StringBuilder)new StringBuilder("hi"), (StringBuilder)new StringBuilder("bye")), (String)"StringBuilders equal");
        Assertions.assertFalse((boolean)IDLTools.equals((StringBuilder)new StringBuilder("bii"), (StringBuilder)new StringBuilder("bye")), (String)"StringBuilders equal");
        Assertions.assertFalse((boolean)IDLTools.equals((StringBuilder)new StringBuilder("hii"), (StringBuilder)new StringBuilder("bye")), (String)"StringBuilders equal");
        Assertions.assertFalse((boolean)IDLTools.equals((StringBuilder)new StringBuilder("a"), (StringBuilder)new StringBuilder("b")), (String)"StringBuilders equal");
    }

    @Test
    public void testStringBuilderEpsilonEquals() {
        Assertions.assertTrue((boolean)IDLTools.epsilonEqualsStringBuilder((StringBuilder)new StringBuilder("hi"), (StringBuilder)new StringBuilder("hi"), (double)0.0), (String)"StringBuilders not equal");
        Assertions.assertFalse((boolean)IDLTools.epsilonEqualsStringBuilder((StringBuilder)new StringBuilder("hi"), (StringBuilder)new StringBuilder("bye"), (double)0.0), (String)"StringBuilders equal");
    }

    @Test
    public void testEpsilonEqualsBoolean() {
        Assertions.assertTrue((boolean)IDLTools.epsilonEqualsBoolean((boolean)true, (boolean)true, (double)0.0), (String)"Booleans not equal");
        Assertions.assertTrue((boolean)IDLTools.epsilonEqualsBoolean((boolean)false, (boolean)false, (double)0.0), (String)"Booleans not equal");
        Assertions.assertFalse((boolean)IDLTools.epsilonEqualsBoolean((boolean)true, (boolean)false, (double)0.0), (String)"Booleans equal");
    }

    @Test
    public void testEpsilonEquals() {
        Assertions.assertTrue((boolean)IDLTools.epsilonEquals((double)0.0, (double)0.0, (double)0.0), (String)"Doubles not equal");
        Assertions.assertTrue((boolean)IDLTools.epsilonEquals((double)0.1, (double)0.2, (double)0.1), (String)"Doubles not equal");
        Assertions.assertFalse((boolean)IDLTools.epsilonEquals((double)0.0, (double)0.1, (double)0.05), (String)"Doubles equal");
        Assertions.assertFalse((boolean)IDLTools.epsilonEquals((double)0.0, (double)5.0, (double)1.0), (String)"Doubles equal");
        Assertions.assertFalse((boolean)IDLTools.epsilonEquals((double)0.0, (double)5.0, (double)0.0), (String)"Doubles equal");
        Assertions.assertTrue((boolean)IDLTools.epsilonEqualsPrimitive((double)0.0, (double)0.0, (double)0.0), (String)"Doubles not equal");
        Assertions.assertTrue((boolean)IDLTools.epsilonEqualsPrimitive((double)0.1, (double)0.2, (double)0.1), (String)"Doubles not equal");
        Assertions.assertFalse((boolean)IDLTools.epsilonEqualsPrimitive((double)0.0, (double)0.1, (double)0.05), (String)"Doubles equal");
        Assertions.assertFalse((boolean)IDLTools.epsilonEqualsPrimitive((double)0.0, (double)5.0, (double)1.0), (String)"Doubles equal");
        Assertions.assertFalse((boolean)IDLTools.epsilonEqualsPrimitive((double)0.0, (double)5.0, (double)0.0), (String)"Doubles equal");
    }

    @Test
    public void testEpsilonEqualsEnum() {
        Assertions.assertTrue((boolean)IDLTools.epsilonEqualsEnum((Enum)SampleEnum.ONE, (Enum)SampleEnum.ONE, (double)0.0), (String)"Enums not equal");
        Assertions.assertTrue((boolean)IDLTools.epsilonEqualsEnum((Enum)SampleEnum.TWO, (Enum)SampleEnum.TWO, (double)0.0), (String)"Enums not equal");
        Assertions.assertFalse((boolean)IDLTools.epsilonEqualsEnum((Enum)SampleEnum.ONE, (Enum)SampleEnum.TWO, (double)0.0), (String)"Enums equal");
    }

    @Test
    public void testStringBuilderEpsilonEqualsSequence() {
        IDLSequence.StringBuilderHolder a = new IDLSequence.StringBuilderHolder(10, "type_d");
        IDLSequence.StringBuilderHolder b = new IDLSequence.StringBuilderHolder(10, "type_d");
        Assertions.assertTrue((boolean)IDLTools.epsilonEqualsStringBuilderSequence((IDLSequence.StringBuilderHolder)a, (IDLSequence.StringBuilderHolder)b, (double)0.0), (String)"Sequences not equal");
        a = new IDLSequence.StringBuilderHolder(5, "type_d");
        b = new IDLSequence.StringBuilderHolder(10, "type_d");
        Assertions.assertTrue((boolean)IDLTools.epsilonEqualsStringBuilderSequence((IDLSequence.StringBuilderHolder)a, (IDLSequence.StringBuilderHolder)b, (double)0.0), (String)"Sequences not equal");
        a = new IDLSequence.StringBuilderHolder(5, "type_d");
        b = new IDLSequence.StringBuilderHolder(10, "type_d");
        a.add("blah");
        Assertions.assertFalse((boolean)IDLTools.epsilonEqualsStringBuilderSequence((IDLSequence.StringBuilderHolder)a, (IDLSequence.StringBuilderHolder)b, (double)0.0), (String)"Sequences equal");
        a = new IDLSequence.StringBuilderHolder(10, "type_d");
        b = new IDLSequence.StringBuilderHolder(10, "type_d");
        a.add("one");
        b.add("one");
        Assertions.assertTrue((boolean)IDLTools.epsilonEqualsStringBuilderSequence((IDLSequence.StringBuilderHolder)a, (IDLSequence.StringBuilderHolder)b, (double)0.0), (String)"Sequences not equal");
        a = new IDLSequence.StringBuilderHolder(5, "type_d");
        b = new IDLSequence.StringBuilderHolder(10, "type_d");
        a.add("one");
        b.add("two");
        Assertions.assertFalse((boolean)IDLTools.epsilonEqualsStringBuilderSequence((IDLSequence.StringBuilderHolder)a, (IDLSequence.StringBuilderHolder)b, (double)0.0), (String)"Sequences equal");
        a = new IDLSequence.StringBuilderHolder(10, "type_d");
        b = new IDLSequence.StringBuilderHolder(10, "type_d");
        a.add("one");
        a.add("two");
        a.add("thr");
        b.add("one");
        b.add("two");
        b.add("thr");
        Assertions.assertTrue((boolean)IDLTools.epsilonEqualsStringBuilderSequence((IDLSequence.StringBuilderHolder)a, (IDLSequence.StringBuilderHolder)b, (double)0.0), (String)"Sequences not equal");
        a = new IDLSequence.StringBuilderHolder(5, "type_d");
        b = new IDLSequence.StringBuilderHolder(10, "type_d");
        a.add("one");
        a.add("one");
        b.add("one");
        b.add("two");
        Assertions.assertFalse((boolean)IDLTools.epsilonEqualsStringBuilderSequence((IDLSequence.StringBuilderHolder)a, (IDLSequence.StringBuilderHolder)b, (double)0.0), (String)"Sequences equal");
    }

    @Test
    public void testEpsilonEqualsEnumSequence() {
        IDLSequence.Enum a = new IDLSequence.Enum(10, SampleEnum.class, (Enum[])SampleEnum.values());
        IDLSequence.Enum b = new IDLSequence.Enum(10, SampleEnum.class, (Enum[])SampleEnum.values());
        Assertions.assertTrue((boolean)IDLTools.epsilonEqualsEnumSequence((IDLSequence.Enum)a, (IDLSequence.Enum)b, (double)0.0), (String)"Sequences not equal");
        a = new IDLSequence.Enum(5, SampleEnum.class, (Enum[])SampleEnum.values());
        b = new IDLSequence.Enum(10, SampleEnum.class, (Enum[])SampleEnum.values());
        Assertions.assertTrue((boolean)IDLTools.epsilonEqualsEnumSequence((IDLSequence.Enum)a, (IDLSequence.Enum)b, (double)0.0), (String)"Sequences not equal");
        a = new IDLSequence.Enum(5, SampleEnum.class, (Enum[])SampleEnum.values());
        b = new IDLSequence.Enum(10, SampleEnum.class, (Enum[])SampleEnum.values());
        a.add((Enum)SampleEnum.ONE);
        Assertions.assertFalse((boolean)IDLTools.epsilonEqualsEnumSequence((IDLSequence.Enum)a, (IDLSequence.Enum)b, (double)0.0), (String)"Sequences equal");
        a = new IDLSequence.Enum(10, SampleEnum.class, (Enum[])SampleEnum.values());
        b = new IDLSequence.Enum(10, SampleEnum.class, (Enum[])SampleEnum.values());
        a.add((Enum)SampleEnum.ONE);
        b.add((Enum)SampleEnum.ONE);
        Assertions.assertTrue((boolean)IDLTools.epsilonEqualsEnumSequence((IDLSequence.Enum)a, (IDLSequence.Enum)b, (double)0.0), (String)"Sequences not equal");
        a = new IDLSequence.Enum(5, SampleEnum.class, (Enum[])SampleEnum.values());
        b = new IDLSequence.Enum(10, SampleEnum.class, (Enum[])SampleEnum.values());
        a.add((Enum)SampleEnum.ONE);
        b.add((Enum)SampleEnum.TWO);
        Assertions.assertFalse((boolean)IDLTools.epsilonEqualsEnumSequence((IDLSequence.Enum)a, (IDLSequence.Enum)b, (double)0.0), (String)"Sequences equal");
        a = new IDLSequence.Enum(10, SampleEnum.class, (Enum[])SampleEnum.values());
        b = new IDLSequence.Enum(10, SampleEnum.class, (Enum[])SampleEnum.values());
        a.add((Enum)SampleEnum.ONE);
        a.add((Enum)SampleEnum.TWO);
        a.add((Enum)SampleEnum.TWO);
        b.add((Enum)SampleEnum.ONE);
        b.add((Enum)SampleEnum.TWO);
        b.add((Enum)SampleEnum.TWO);
        Assertions.assertTrue((boolean)IDLTools.epsilonEqualsEnumSequence((IDLSequence.Enum)a, (IDLSequence.Enum)b, (double)0.0), (String)"Sequences not equal");
        a = new IDLSequence.Enum(5, SampleEnum.class, (Enum[])SampleEnum.values());
        b = new IDLSequence.Enum(10, SampleEnum.class, (Enum[])SampleEnum.values());
        a.add((Enum)SampleEnum.ONE);
        a.add((Enum)SampleEnum.ONE);
        b.add((Enum)SampleEnum.ONE);
        b.add((Enum)SampleEnum.TWO);
        Assertions.assertFalse((boolean)IDLTools.epsilonEqualsEnumSequence((IDLSequence.Enum)a, (IDLSequence.Enum)b, (double)0.0), (String)"Sequences equal");
    }

    @Test
    public void testEpsilonEqualsSequenceBoolean() {
        IDLSequence.Boolean a = new IDLSequence.Boolean(10, "type_7");
        IDLSequence.Boolean b = new IDLSequence.Boolean(10, "type_7");
        Assertions.assertTrue((boolean)IDLTools.epsilonEqualsBooleanSequence((IDLSequence.Boolean)a, (IDLSequence.Boolean)b, (double)0.0), (String)"Sequences not equal");
        a = new IDLSequence.Boolean(5, "type_7");
        b = new IDLSequence.Boolean(10, "type_7");
        Assertions.assertTrue((boolean)IDLTools.epsilonEqualsBooleanSequence((IDLSequence.Boolean)a, (IDLSequence.Boolean)b, (double)0.0), (String)"Sequences not equal");
        a = new IDLSequence.Boolean(5, "type_7");
        b = new IDLSequence.Boolean(10, "type_7");
        a.add(true);
        Assertions.assertFalse((boolean)IDLTools.epsilonEqualsBooleanSequence((IDLSequence.Boolean)a, (IDLSequence.Boolean)b, (double)0.0), (String)"Sequences equal");
        a = new IDLSequence.Boolean(10, "type_7");
        b = new IDLSequence.Boolean(10, "type_7");
        a.add(true);
        b.add(true);
        Assertions.assertTrue((boolean)IDLTools.epsilonEqualsBooleanSequence((IDLSequence.Boolean)a, (IDLSequence.Boolean)b, (double)0.0), (String)"Sequences not equal");
        a = new IDLSequence.Boolean(5, "type_7");
        b = new IDLSequence.Boolean(10, "type_7");
        a.add(true);
        b.add(false);
        Assertions.assertFalse((boolean)IDLTools.epsilonEqualsBooleanSequence((IDLSequence.Boolean)a, (IDLSequence.Boolean)b, (double)0.0), (String)"Sequences equal");
        a = new IDLSequence.Boolean(10, "type_7");
        b = new IDLSequence.Boolean(10, "type_7");
        a.add(true);
        a.add(false);
        a.add(true);
        b.add(true);
        b.add(false);
        b.add(true);
        Assertions.assertTrue((boolean)IDLTools.epsilonEqualsBooleanSequence((IDLSequence.Boolean)a, (IDLSequence.Boolean)b, (double)0.0), (String)"Sequences not equal");
        a = new IDLSequence.Boolean(5, "type_7");
        b = new IDLSequence.Boolean(10, "type_7");
        a.add(true);
        a.add(true);
        b.add(true);
        b.add(false);
        Assertions.assertFalse((boolean)IDLTools.epsilonEqualsBooleanSequence((IDLSequence.Boolean)a, (IDLSequence.Boolean)b, (double)0.0), (String)"Sequences equal");
    }

    @Test
    public void testEpsilonEqualsSequenceByte() {
        IDLSequence.Byte a = new IDLSequence.Byte(10, "type_9");
        IDLSequence.Byte b = new IDLSequence.Byte(10, "type_9");
        Assertions.assertTrue((boolean)IDLTools.epsilonEqualsByteSequence((IDLSequence.Byte)a, (IDLSequence.Byte)b, (double)0.0), (String)"Sequences not equal");
        a = new IDLSequence.Byte(5, "type_9");
        b = new IDLSequence.Byte(10, "type_9");
        Assertions.assertTrue((boolean)IDLTools.epsilonEqualsByteSequence((IDLSequence.Byte)a, (IDLSequence.Byte)b, (double)0.0), (String)"Sequences not equal");
        a = new IDLSequence.Byte(5, "type_9");
        b = new IDLSequence.Byte(10, "type_9");
        a.add((byte)0);
        Assertions.assertFalse((boolean)IDLTools.epsilonEqualsByteSequence((IDLSequence.Byte)a, (IDLSequence.Byte)b, (double)0.0), (String)"Sequences equal");
        a = new IDLSequence.Byte(10, "type_9");
        b = new IDLSequence.Byte(10, "type_9");
        a.add((byte)0);
        b.add((byte)0);
        Assertions.assertTrue((boolean)IDLTools.epsilonEqualsByteSequence((IDLSequence.Byte)a, (IDLSequence.Byte)b, (double)0.0), (String)"Sequences not equal");
        a = new IDLSequence.Byte(5, "type_9");
        b = new IDLSequence.Byte(10, "type_9");
        a.add((byte)0);
        b.add((byte)-1);
        Assertions.assertFalse((boolean)IDLTools.epsilonEqualsByteSequence((IDLSequence.Byte)a, (IDLSequence.Byte)b, (double)0.0), (String)"Sequences equal");
        a = new IDLSequence.Byte(10, "type_9");
        b = new IDLSequence.Byte(10, "type_9");
        a.add((byte)0);
        a.add((byte)-1);
        a.add((byte)-1);
        b.add((byte)0);
        b.add((byte)-1);
        b.add((byte)-1);
        Assertions.assertTrue((boolean)IDLTools.epsilonEqualsByteSequence((IDLSequence.Byte)a, (IDLSequence.Byte)b, (double)0.0), (String)"Sequences not equal");
        a = new IDLSequence.Byte(5, "type_9");
        b = new IDLSequence.Byte(10, "type_9");
        a.add((byte)0);
        a.add((byte)0);
        b.add((byte)0);
        b.add((byte)-1);
        Assertions.assertFalse((boolean)IDLTools.epsilonEqualsByteSequence((IDLSequence.Byte)a, (IDLSequence.Byte)b, (double)0.0), (String)"Sequences equal");
    }

    @Test
    public void testEpsilonEqualsSequenceChar() {
        IDLSequence.Char a = new IDLSequence.Char(10, "type_8");
        IDLSequence.Char b = new IDLSequence.Char(10, "type_8");
        a.add('a');
        a.add('b');
        a.add('c');
        b.add('a');
        b.add('b');
        b.add('c');
        Assertions.assertTrue((boolean)IDLTools.epsilonEqualsCharSequence((IDLSequence.Char)a, (IDLSequence.Char)b, (double)0.0), (String)"Sequences not equal");
        a = new IDLSequence.Char(5, "type_8");
        b = new IDLSequence.Char(10, "type_8");
        a.add('a');
        a.add('a');
        b.add('a');
        b.add('b');
        Assertions.assertFalse((boolean)IDLTools.epsilonEqualsCharSequence((IDLSequence.Char)a, (IDLSequence.Char)b, (double)0.0), (String)"Sequences equal");
    }

    @Test
    public void testEpsilonEqualsSequenceShort() {
        IDLSequence.Short a = new IDLSequence.Short(10, "type_1");
        IDLSequence.Short b = new IDLSequence.Short(10, "type_1");
        a.add((short)0);
        a.add((short)4);
        a.add((short)-1);
        b.add((short)0);
        b.add((short)4);
        b.add((short)-1);
        Assertions.assertTrue((boolean)IDLTools.epsilonEqualsShortSequence((IDLSequence.Short)a, (IDLSequence.Short)b, (double)0.0), (String)"Sequences not equal");
        a = new IDLSequence.Short(5, "type_1");
        b = new IDLSequence.Short(10, "type_1");
        a.add((short)0);
        a.add((short)0);
        b.add((short)0);
        b.add((short)4);
        Assertions.assertFalse((boolean)IDLTools.epsilonEqualsShortSequence((IDLSequence.Short)a, (IDLSequence.Short)b, (double)0.0), (String)"Sequences equal");
    }

    @Test
    public void testEpsilonEqualsSequenceInteger() {
        IDLSequence.Integer a = new IDLSequence.Integer(10, "type_2");
        IDLSequence.Integer b = new IDLSequence.Integer(10, "type_2");
        a.add(0);
        a.add(4);
        a.add(-1);
        b.add(0);
        b.add(4);
        b.add(-1);
        Assertions.assertTrue((boolean)IDLTools.epsilonEqualsIntegerSequence((IDLSequence.Integer)a, (IDLSequence.Integer)b, (double)0.0), (String)"Sequences not equal");
        a = new IDLSequence.Integer(5, "type_2");
        b = new IDLSequence.Integer(10, "type_2");
        a.add(0);
        a.add(0);
        b.add(0);
        b.add(4);
        Assertions.assertFalse((boolean)IDLTools.epsilonEqualsIntegerSequence((IDLSequence.Integer)a, (IDLSequence.Integer)b, (double)0.0), (String)"Sequences equal");
    }

    @Test
    public void testEpsilonEqualsSequenceLong() {
        IDLSequence.Long a = new IDLSequence.Long(10, "type_11");
        IDLSequence.Long b = new IDLSequence.Long(10, "type_11");
        a.add(0L);
        a.add(4L);
        a.add(-1L);
        b.add(0L);
        b.add(4L);
        b.add(-1L);
        Assertions.assertTrue((boolean)IDLTools.epsilonEqualsLongSequence((IDLSequence.Long)a, (IDLSequence.Long)b, (double)0.0), (String)"Sequences not equal");
        a = new IDLSequence.Long(5, "type_11");
        b = new IDLSequence.Long(10, "type_11");
        a.add(0L);
        a.add(0L);
        b.add(0L);
        b.add(4L);
        Assertions.assertFalse((boolean)IDLTools.epsilonEqualsLongSequence((IDLSequence.Long)a, (IDLSequence.Long)b, (double)0.0), (String)"Sequences equal");
    }

    @Test
    public void testEpsilonEqualsSequenceFloat() {
        IDLSequence.Float a = new IDLSequence.Float(10, "type_5");
        IDLSequence.Float b = new IDLSequence.Float(10, "type_5");
        a.add(0.0f);
        a.add(4.0f);
        a.add(-1.0f);
        b.add(0.0f);
        b.add(4.0f);
        b.add(-1.0f);
        Assertions.assertTrue((boolean)IDLTools.epsilonEqualsFloatSequence((IDLSequence.Float)a, (IDLSequence.Float)b, (double)0.0), (String)"Sequences not equal");
        a = new IDLSequence.Float(5, "type_5");
        b = new IDLSequence.Float(10, "type_5");
        a.add(0.0f);
        a.add(0.0f);
        b.add(0.0f);
        b.add(4.0f);
        Assertions.assertFalse((boolean)IDLTools.epsilonEqualsFloatSequence((IDLSequence.Float)a, (IDLSequence.Float)b, (double)0.0), (String)"Sequences equal");
    }

    @Test
    public void testEpsilonEqualsSequenceDouble() {
        IDLSequence.Double a = new IDLSequence.Double(10, "type_6");
        IDLSequence.Double b = new IDLSequence.Double(10, "type_6");
        a.add(0.0);
        a.add(1.5);
        a.add(-3.0);
        b.add(0.0);
        b.add(1.5);
        b.add(-3.0);
        Assertions.assertTrue((boolean)IDLTools.epsilonEqualsDoubleSequence((IDLSequence.Double)a, (IDLSequence.Double)b, (double)0.0), (String)"Sequences not equal");
        a = new IDLSequence.Double(5, "type_6");
        b = new IDLSequence.Double(10, "type_6");
        a.add(0.0);
        a.add(0.0);
        b.add(0.0);
        b.add(1.5);
        Assertions.assertFalse((boolean)IDLTools.epsilonEqualsDoubleSequence((IDLSequence.Double)a, (IDLSequence.Double)b, (double)0.0), (String)"Sequences equal");
    }

    public static void main(String[] args) {
        MutationTestFacilitator.facilitateMutationTestForClass(IDLTools.class, IDLToolsTest.class);
    }

    private static enum SampleEnum {
        ONE,
        TWO;

    }
}

