/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.idl.generator;

import com.eprosima.idl.generator.manager.TemplateManager;
import com.eprosima.idl.parser.tree.Annotation;
import com.eprosima.idl.parser.tree.Definition;
import com.eprosima.idl.parser.tree.Export;
import com.eprosima.idl.parser.tree.Interface;
import com.eprosima.idl.parser.tree.Module;
import com.eprosima.idl.parser.tree.TypeDeclaration;
import com.eprosima.idl.parser.typecode.ContainerTypeCode;
import com.eprosima.idl.parser.typecode.EnumTypeCode;
import com.eprosima.idl.parser.typecode.Member;
import com.eprosima.idl.parser.typecode.TypeCode;
import com.eprosima.idl.parser.typecode.UnionTypeCode;
import com.eprosima.log.ColorMessage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import us.ihmc.idl.generator.AbstractStructTypeCode;
import us.ihmc.idl.generator.AbstractTypeDeclaration;
import us.ihmc.idl.generator.IDLContext;
import us.ihmc.idl.generator.StructTypeCode;

class TypesGenerator {
    private static final String PUB_SUB_TYPE_NAME = "PubSubType";
    private final HashMap<TypeCode, AbstractStructTypeCode> updatedTypes = new HashMap();
    private final ArrayList<Member> members = new ArrayList();
    private TemplateManager tmanager_ = null;
    private boolean replace_ = false;

    TypesGenerator(TemplateManager tmanager, boolean replace) {
        this.tmanager_ = tmanager;
        this.replace_ = replace;
    }

    boolean generate(IDLContext context, String packagDir, String packag, Map<String, String> extensions) {
        ArrayList<Definition> definitions = context.getDefinitions();
        this.processAbstractDefinitions(definitions);
        StringTemplateGroup javaTypeTemplate = this.tmanager_.createStringTemplateGroup("JavaType");
        boolean returnedValue = this.processDefinitions(javaTypeTemplate, context, definitions, packagDir, packag, "", extensions);
        if (returnedValue) {
            StringTemplateGroup javaPubSubTypeTemplate = this.tmanager_.createStringTemplateGroup("JavaPubSubType");
            returnedValue = this.processDefinitions(javaPubSubTypeTemplate, context, definitions, packagDir, packag, PUB_SUB_TYPE_NAME, extensions);
        }
        return returnedValue;
    }

    private void processAbstractDefinitions(ArrayList<Definition> definitions) {
        if (definitions != null) {
            for (int i = 0; i < definitions.size(); ++i) {
                TypeDeclaration typedecl;
                Definition definition = definitions.get(i);
                if (definition.isIsModule()) {
                    Module module = (Module)definition;
                    this.processAbstractDefinitions(module.getDefinitions());
                    continue;
                }
                if (!definition.isIsTypeDeclaration() || (typedecl = (TypeDeclaration)definition).getTypeCode().getKind() != 10) continue;
                boolean abstractAnnotation = typedecl.getAnnotations().containsKey("Abstract");
                if (abstractAnnotation) {
                    AbstractTypeDeclaration newDeclaration = new AbstractTypeDeclaration(typedecl);
                    definitions.set(i, (Definition)newDeclaration);
                    this.updatedTypes.put(typedecl.getTypeCode(), (AbstractStructTypeCode)newDeclaration.getTypeCode());
                }
                this.members.addAll(((StructTypeCode)typedecl.getTypeCode()).getMembers());
            }
            block1: for (Member member : this.members) {
                ContainerTypeCode containerTypeCode;
                if (this.updatedTypes.containsKey(member.getTypecode())) {
                    member.setTypecode((TypeCode)this.updatedTypes.get(member.getTypecode()));
                    continue;
                }
                if (member.getTypecode().getKind() != 14 && member.getTypecode().getKind() != 15 || (containerTypeCode = (ContainerTypeCode)member.getTypecode()).getContentTypeCode().getKind() != 10) continue;
                for (AbstractStructTypeCode entry : this.updatedTypes.values()) {
                    if (!entry.getIdlTypename().equals(containerTypeCode.getContentTypeCode().getIdlTypename())) continue;
                    containerTypeCode.setContentTypeCode((TypeCode)entry);
                    continue block1;
                }
            }
        }
    }

    private boolean isInScope(IDLContext context, String filename) {
        Path input = Paths.get(context.getIDLFileName(), new String[0]);
        Path current = Paths.get(filename, new String[0]);
        try {
            return Files.isSameFile(input, current);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean processDefinitions(StringTemplateGroup stg_, IDLContext context, ArrayList<Definition> definitions, String packagDir, String packag, String moduleNamePostfix, Map<String, String> extensions) {
        if (definitions != null) {
            for (Definition definition : definitions) {
                StringTemplate typest;
                boolean notAbstractDefinition;
                TypeDeclaration typedecl;
                if (definition.isIsModule()) {
                    Object packageName;
                    Module module = (Module)definition;
                    if (!this.isInScope(context, module.getScopeFile())) continue;
                    String outputDir = packagDir + module.getName();
                    File dir = new File(outputDir);
                    if (!dir.exists() && !dir.mkdir()) {
                        System.out.println(ColorMessage.error() + "Cannot create directory for module " + module.getName());
                        return false;
                    }
                    Object object = packageName = packag.isEmpty() ? "" : packag + ".";
                    if (this.processDefinitions(stg_, context, module.getDefinitions(), outputDir + File.separator, (String)packageName + module.getName(), moduleNamePostfix, extensions)) continue;
                    return false;
                }
                if (definition.isIsInterface()) {
                    Interface ifc = (Interface)definition;
                    if (!this.isInScope(context, ifc.getScopeFile())) continue;
                    StringTemplate ifcst = stg_.getInstanceOf("interface");
                    ifcst.setAttribute("ctx", (Object)context);
                    ifcst.setAttribute("parent", ifc.getParent());
                    ifcst.setAttribute("interface", (Object)ifc);
                    StringTemplate extensionst = null;
                    String extensionname = null;
                    if (extensions != null && (extensionname = extensions.get("interface")) != null) {
                        extensionst = stg_.getInstanceOf(extensionname);
                        extensionst.setAttribute("ctx", (Object)context);
                        extensionst.setAttribute("parent", ifc.getParent());
                        extensionst.setAttribute("interface", (Object)ifc);
                        ifcst.setAttribute("extension", (Object)extensionst.toString());
                    }
                    if (this.processExports(stg_, context, ifc.getExports(), ifcst, extensions)) {
                        StringTemplate st = stg_.getInstanceOf("main");
                        st.setAttribute("ctx", (Object)context);
                        st.setAttribute("definitions", (Object)ifcst.toString());
                        st.setAttribute("package", (Object)(!packag.isEmpty() ? packag : null));
                        if (extensions != null && (extensionname = extensions.get("main")) != null) {
                            extensionst = stg_.getInstanceOf(extensionname);
                            extensionst.setAttribute("ctx", (Object)context);
                            st.setAttribute("extension", (Object)extensionst.toString());
                        }
                        String fileName = packagDir + ifc.getName() + moduleNamePostfix + ".java";
                        System.out.println("[IDL -> PubSub] Generating " + fileName);
                        if (this.writeFile(fileName, st)) continue;
                        System.out.println(ColorMessage.error() + "Cannot write file " + packagDir + ifc.getName() + ".java");
                        return false;
                    }
                    return false;
                }
                if (!definition.isIsTypeDeclaration() || !this.isInScope(context, (typedecl = (TypeDeclaration)definition).getScopeFile())) continue;
                boolean abstractAnnotation = typedecl.getAnnotations().containsKey("Abstract");
                boolean notEnumPubSubType = !moduleNamePostfix.equals(PUB_SUB_TYPE_NAME) || typedecl.getTypeCode().getKind() != 12;
                boolean bl = notAbstractDefinition = moduleNamePostfix.equals(PUB_SUB_TYPE_NAME) || !abstractAnnotation;
                if (!notEnumPubSubType || !notAbstractDefinition || (typest = this.processTypeDeclaration(stg_, context, typedecl, extensions)) == null) continue;
                StringTemplate st = stg_.getInstanceOf("main");
                st.setAttribute("ctx", (Object)context);
                st.setAttribute("definitions", (Object)typest.toString());
                st.setAttribute("package", (Object)(!packag.isEmpty() ? packag : null));
                StringTemplate extensionst = null;
                String extensionname = null;
                if (extensions != null && (extensionname = extensions.get("main")) != null) {
                    extensionst = stg_.getInstanceOf(extensionname);
                    extensionst.setAttribute("ctx", (Object)context);
                    st.setAttribute("extension", (Object)extensionst.toString());
                }
                String fileName = packagDir + typedecl.getName() + moduleNamePostfix + ".java";
                System.out.println("[IDL -> PubSub] Generating " + fileName);
                if (this.writeFile(fileName, st)) continue;
                System.out.println(ColorMessage.error() + "Cannot write file " + packagDir + typedecl.getName() + ".java");
                return false;
            }
        }
        return true;
    }

    boolean processExports(StringTemplateGroup stg_, IDLContext context, ArrayList<Export> exports, StringTemplate ifcst, Map<String, String> extensions) {
        for (Export export : exports) {
            TypeDeclaration typedecl;
            StringTemplate typest;
            if (!export.isIsTypeDeclaration() || (typest = this.processTypeDeclaration(stg_, context, typedecl = (TypeDeclaration)export, extensions)) == null) continue;
            ifcst.setAttribute("exports", (Object)typest.toString());
        }
        return true;
    }

    StringTemplate processTypeDeclaration(StringTemplateGroup stg_, IDLContext context, TypeDeclaration typedecl, Map<String, String> extensions) {
        StringTemplate typest = null;
        StringTemplate extensionst = null;
        String extensionname = null;
        if (typedecl.getTypeCode().getKind() == 10) {
            typest = stg_.getInstanceOf("struct_type");
            typest.setAttribute("struct", (Object)typedecl.getTypeCode());
            if (typedecl.getAnnotations().containsKey("TypeCode")) {
                typest.setAttribute("typecode", (Object)this.getTypeCodeAnnotation(typedecl));
            } else {
                typest.setAttribute("typecode", (Object)((StructTypeCode)typedecl.getTypeCode()).getScopedname());
            }
            if (extensions != null && (extensionname = extensions.get("struct_type")) != null) {
                extensionst = stg_.getInstanceOf(extensionname);
                extensionst.setAttribute("struct", (Object)typedecl.getTypeCode());
            }
        } else if (typedecl.getTypeCode().getKind() == 11) {
            typest = stg_.getInstanceOf("union_type");
            typest.setAttribute("union", (Object)typedecl.getTypeCode());
            if (typedecl.getAnnotations().containsKey("TypeCode")) {
                typest.setAttribute("typecode", (Object)this.getTypeCodeAnnotation(typedecl));
            } else {
                typest.setAttribute("typecode", (Object)((UnionTypeCode)typedecl.getTypeCode()).getScopedname());
            }
            if (extensions != null && (extensionname = extensions.get("union_type")) != null) {
                extensionst = stg_.getInstanceOf(extensionname);
                extensionst.setAttribute("union", (Object)typedecl.getTypeCode());
            }
        } else if (typedecl.getTypeCode().getKind() == 12) {
            typest = stg_.getInstanceOf("enum_type");
            typest.setAttribute("enum", (Object)typedecl.getTypeCode());
            if (typedecl.getAnnotations().containsKey("TypeCode")) {
                typest.setAttribute("typecode", (Object)this.getTypeCodeAnnotation(typedecl));
            } else {
                typest.setAttribute("typecode", (Object)((EnumTypeCode)typedecl.getTypeCode()).getScopedname());
            }
            if (extensions != null && (extensionname = extensions.get("enum_type")) != null) {
                extensionst = stg_.getInstanceOf(extensionname);
                extensionst.setAttribute("enum", (Object)typedecl.getTypeCode());
            }
        }
        if (typest != null) {
            if (extensionst != null) {
                extensionst.setAttribute("ctx", (Object)context);
                extensionst.setAttribute("parent", typedecl.getParent());
                typest.setAttribute("extension", (Object)extensionst.toString());
            }
            typest.setAttribute("ctx", (Object)context);
            typest.setAttribute("parent", typedecl.getParent());
        }
        return typest;
    }

    private String getTypeCodeAnnotation(TypeDeclaration typedecl) {
        String raw = ((Annotation)typedecl.getAnnotations().get("TypeCode")).getValue("type");
        return raw.substring(1, raw.length() - 1);
    }

    private boolean writeFile(String file, StringTemplate template) {
        boolean returnedValue = false;
        try {
            File handle = new File(file);
            if (!handle.exists() || this.replace_) {
                FileWriter fw = new FileWriter(file);
                String data = template.toString();
                data = data.replaceAll("\r\n", "\n");
                fw.write(data, 0, data.length());
                fw.close();
            } else {
                System.out.println("INFO: " + file + " exists. Skipping.");
            }
            returnedValue = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return returnedValue;
    }
}

