/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.jupiter.api.Test;
import us.ihmc.idl.IDLSequence;
import us.ihmc.idl.IDLTools;
import us.ihmc.idl.generated.nested.NestedElement;
import us.ihmc.idl.generated.test.Color;
import us.ihmc.idl.generated.test.IDLElementTest;
import us.ihmc.pubsub.tools.PubSubTester;

public class TypesOverNetworkTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSerializationOfAllTypesOverRealNetwork() throws IOException {
        PubSubTester<IDLElementTest> tester = new PubSubTester<IDLElementTest>(IDLElementTest::new);
        try {
            int NUMBER_MESSAGES_TO_SEND = 10;
            Random random = new Random(2934810948124L);
            IDLElementTest[] messageArray = new IDLElementTest[NUMBER_MESSAGES_TO_SEND];
            for (int i = 0; i < NUMBER_MESSAGES_TO_SEND; ++i) {
                messageArray[i] = this.populateIDLElementTest(new IDLElementTest(), random, i);
            }
            ArrayList errors = new ArrayList();
            tester.callbacks.add((data, info) -> {
                System.out.println("Receiving: " + data.getStringTestAsString());
                for (int i = 0; i < NUMBER_MESSAGES_TO_SEND; ++i) {
                    if (!messageArray[i].getStringTestAsString().equals(data.getStringTestAsString())) continue;
                    System.out.println("Looking for errors...");
                    ArrayList<AssertionError> localErrors = this.epsilonEquals(messageArray[i], (IDLElementTest)((Object)data), 0.0);
                    errors.addAll(localErrors);
                    for (AssertionError error : localErrors) {
                        ((Throwable)((Object)error)).printStackTrace();
                    }
                }
            });
            for (int i = 0; i < NUMBER_MESSAGES_TO_SEND; ++i) {
                try {
                    tester.publisher.write((Object)messageArray[i]);
                    System.out.println("Publishing: " + messageArray[i].getStringTestAsString());
                    Thread.sleep(200L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            System.out.println("Num errors: " + errors.size());
            Iterator iterator = errors.iterator();
            if (iterator.hasNext()) {
                AssertionError error = (AssertionError)iterator.next();
                throw error;
            }
        }
        finally {
            tester.domain.stopAll();
        }
    }

    private IDLElementTest populateIDLElementTest(IDLElementTest test, Random random, int index) {
        test.setCharTest(RandomStringUtils.random((int)1, (int)32, (int)127, (boolean)false, (boolean)false, null, (Random)random).charAt(0));
        test.setWcharTest(RandomStringUtils.random((int)1, (int)32, (int)127, (boolean)false, (boolean)false, null, (Random)random).charAt(0));
        test.setOctetTest(this.nextByte(random));
        test.setShortTest((short)random.nextInt(32768));
        test.setUshortTest(random.nextInt(65535));
        test.setLongTest(random.nextInt());
        long uint32 = random.nextLong();
        test.setUlongTest((uint32 < 0L ? -uint32 : uint32) % 0xFFFFFFFFL);
        test.setLonglongTest(random.nextLong());
        test.setUlonglongTest(random.nextLong());
        test.setFloatTest(random.nextFloat());
        test.setDoubleTest(random.nextDouble());
        test.setBooleanTest(random.nextBoolean());
        test.setColorTest(Color.values[random.nextInt(Color.values.length - 1)]);
        test.getNestedElementTest().setLongTest(random.nextInt());
        test.getNestedElementTest().getStringTest().append(RandomStringUtils.random((int)20, (int)32, (int)127, (boolean)false, (boolean)false, null, (Random)random));
        test.getStringTest().append(index);
        return test;
    }

    private byte nextByte(Random random) {
        byte[] bytes = new byte[1];
        random.nextBytes(bytes);
        return bytes[0];
    }

    public ArrayList<AssertionError> epsilonEquals(IDLElementTest msg, IDLElementTest other, double epsilon) {
        ArrayList<AssertionError> errors = new ArrayList<AssertionError>();
        if (other == null) {
            errors.add(new AssertionError((Object)(String.valueOf((Object)other) + " was null")));
        }
        if (other == msg) {
            return errors;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)msg.charTest_, (double)other.charTest_, (double)epsilon)) {
            errors.add(new AssertionError((Object)("charTest_: msg: " + msg.charTest_ + " other:" + other.charTest_)));
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)msg.wcharTest_, (double)other.wcharTest_, (double)epsilon)) {
            errors.add(new AssertionError((Object)("wcharTest_: msg: " + msg.wcharTest_ + " other:" + other.wcharTest_)));
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)msg.octetTest_, (double)other.octetTest_, (double)epsilon)) {
            errors.add(new AssertionError((Object)("octetTest_: msg: " + msg.octetTest_ + " other:" + other.octetTest_)));
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)msg.shortTest_, (double)other.shortTest_, (double)epsilon)) {
            errors.add(new AssertionError((Object)("shortTest_: msg: " + msg.shortTest_ + " other:" + other.shortTest_)));
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)msg.ushortTest_, (double)other.ushortTest_, (double)epsilon)) {
            errors.add(new AssertionError((Object)("ushortTest_: msg: " + msg.ushortTest_ + " other:" + other.ushortTest_)));
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)msg.longTest_, (double)other.longTest_, (double)epsilon)) {
            errors.add(new AssertionError((Object)("longTest_: msg: " + msg.longTest_ + " other:" + other.longTest_)));
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)msg.ulongTest_, (double)other.ulongTest_, (double)epsilon)) {
            errors.add(new AssertionError((Object)("ulongTest_: msg: " + msg.ulongTest_ + " other:" + other.ulongTest_)));
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)msg.longlongTest_, (double)other.longlongTest_, (double)epsilon)) {
            errors.add(new AssertionError((Object)("longlongTest_: msg: " + msg.longlongTest_ + " other:" + other.longlongTest_)));
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)msg.ulonglongTest_, (double)other.ulonglongTest_, (double)epsilon)) {
            errors.add(new AssertionError((Object)("ulonglongTest_: msg: " + msg.ulonglongTest_ + " other:" + other.ulonglongTest_)));
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)msg.floatTest_, (double)other.floatTest_, (double)epsilon)) {
            errors.add(new AssertionError((Object)("floatTest_: msg: " + msg.floatTest_ + " other:" + other.floatTest_)));
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)msg.doubleTest_, (double)other.doubleTest_, (double)epsilon)) {
            errors.add(new AssertionError((Object)("doubleTest_: msg: " + msg.doubleTest_ + " other:" + other.doubleTest_)));
        }
        if (!IDLTools.epsilonEqualsBoolean((boolean)msg.booleanTest_, (boolean)other.booleanTest_, (double)epsilon)) {
            errors.add(new AssertionError((Object)("booleanTest_: msg: " + msg.booleanTest_ + " other:" + other.booleanTest_)));
        }
        if (!IDLTools.epsilonEqualsEnum((Enum)msg.colorTest_, (Enum)other.colorTest_, (double)epsilon)) {
            errors.add(new AssertionError((Object)("colorTest_: msg: " + String.valueOf((Object)msg.colorTest_) + " other:" + String.valueOf((Object)other.colorTest_))));
        }
        if (!msg.nestedElementTest_.epsilonEquals(other.nestedElementTest_, epsilon)) {
            errors.add(new AssertionError((Object)("nestedElementTest_: msg: " + String.valueOf((Object)msg.nestedElementTest_) + " other:" + String.valueOf((Object)other.nestedElementTest_))));
        }
        if (!IDLTools.epsilonEqualsStringBuilder((StringBuilder)msg.stringTest_, (StringBuilder)other.stringTest_, (double)epsilon)) {
            errors.add(new AssertionError((Object)("stringTest_: msg: " + String.valueOf(msg.stringTest_) + " other:" + String.valueOf(other.stringTest_))));
        }
        for (int i15 = 0; i15 < msg.longArray_.length; ++i15) {
            if (IDLTools.epsilonEqualsPrimitive((double)msg.longArray_[i15], (double)other.longArray_[i15], (double)epsilon)) continue;
            errors.add(new AssertionError((Object)("longArray_[i15]: msg: " + msg.longArray_[i15] + " other:" + other.longArray_[i15])));
        }
        for (int i17 = 0; i17 < msg.nestedArray_.length; ++i17) {
            for (int i18 = 0; i18 < msg.nestedArray_[i17].length; ++i18) {
                if (msg.nestedArray_[i17][i18].epsilonEquals(other.nestedArray_[i17][i18], epsilon)) continue;
                errors.add(new AssertionError((Object)("nestedArray_[i17][i18]: msg: " + String.valueOf((Object)msg.nestedArray_[i17][i18]) + " other:" + String.valueOf((Object)other.nestedArray_[i17][i18]))));
            }
        }
        for (int i20 = 0; i20 < msg.stringArray_.length; ++i20) {
            if (IDLTools.epsilonEqualsStringBuilder((StringBuilder)msg.stringArray_[i20], (StringBuilder)other.stringArray_[i20], (double)epsilon)) continue;
            errors.add(new AssertionError((Object)("stringArray_[i20]: msg: " + String.valueOf(msg.stringArray_[i20]) + " other:" + String.valueOf(other.stringArray_[i20]))));
        }
        for (int i22 = 0; i22 < msg.enumArray_.length; ++i22) {
            if (IDLTools.epsilonEqualsEnum((Enum)msg.enumArray_[i22], (Enum)other.enumArray_[i22], (double)epsilon)) continue;
            errors.add(new AssertionError((Object)("enumArray_[i22]: msg: " + String.valueOf((Object)msg.enumArray_[i22]) + " other:" + String.valueOf((Object)other.enumArray_[i22]))));
        }
        if (!IDLTools.epsilonEqualsCharSequence((IDLSequence.Char)msg.charSeqTest_, (IDLSequence.Char)other.charSeqTest_, (double)epsilon)) {
            errors.add(new AssertionError((Object)("charSeqTest_: msg: " + String.valueOf(msg.charSeqTest_) + " other:" + String.valueOf(other.charSeqTest_))));
        }
        if (!IDLTools.epsilonEqualsCharSequence((IDLSequence.Char)msg.wcharSeqTest_, (IDLSequence.Char)other.wcharSeqTest_, (double)epsilon)) {
            errors.add(new AssertionError((Object)("wcharSeqTest_: msg: " + String.valueOf(msg.wcharSeqTest_) + " other:" + String.valueOf(other.wcharSeqTest_))));
        }
        if (!IDLTools.epsilonEqualsByteSequence((IDLSequence.Byte)msg.octetSeqTest_, (IDLSequence.Byte)other.octetSeqTest_, (double)epsilon)) {
            errors.add(new AssertionError((Object)("octetSeqTest_: msg: " + String.valueOf(msg.octetSeqTest_) + " other:" + String.valueOf(other.octetSeqTest_))));
        }
        if (!IDLTools.epsilonEqualsShortSequence((IDLSequence.Short)msg.shortSeqTest_, (IDLSequence.Short)other.shortSeqTest_, (double)epsilon)) {
            errors.add(new AssertionError((Object)("shortSeqTest_: msg: " + String.valueOf(msg.shortSeqTest_) + " other:" + String.valueOf(other.shortSeqTest_))));
        }
        if (!IDLTools.epsilonEqualsIntegerSequence((IDLSequence.Integer)msg.ushortSeqTest_, (IDLSequence.Integer)other.ushortSeqTest_, (double)epsilon)) {
            errors.add(new AssertionError((Object)("ushortSeqTest_: msg: " + String.valueOf(msg.ushortSeqTest_) + " other:" + String.valueOf(other.ushortSeqTest_))));
        }
        if (!IDLTools.epsilonEqualsIntegerSequence((IDLSequence.Integer)msg.longSeqTest_, (IDLSequence.Integer)other.longSeqTest_, (double)epsilon)) {
            errors.add(new AssertionError((Object)("longSeqTest_: msg: " + String.valueOf(msg.longSeqTest_) + " other:" + String.valueOf(other.longSeqTest_))));
        }
        if (!IDLTools.epsilonEqualsLongSequence((IDLSequence.Long)msg.ulongSeqTest_, (IDLSequence.Long)other.ulongSeqTest_, (double)epsilon)) {
            errors.add(new AssertionError((Object)("ulongSeqTest_: msg: " + String.valueOf(msg.ulongSeqTest_) + " other:" + String.valueOf(other.ulongSeqTest_))));
        }
        if (!IDLTools.epsilonEqualsLongSequence((IDLSequence.Long)msg.longlongSeqtest_, (IDLSequence.Long)other.longlongSeqtest_, (double)epsilon)) {
            errors.add(new AssertionError((Object)("longlongSeqtest_: msg: " + String.valueOf(msg.longlongSeqtest_) + " other:" + String.valueOf(other.longlongSeqtest_))));
        }
        if (!IDLTools.epsilonEqualsLongSequence((IDLSequence.Long)msg.ulonglongSeqTest_, (IDLSequence.Long)other.ulonglongSeqTest_, (double)epsilon)) {
            errors.add(new AssertionError((Object)("ulonglongSeqTest_: msg: " + String.valueOf(msg.ulonglongSeqTest_) + " other:" + String.valueOf(other.ulonglongSeqTest_))));
        }
        if (!IDLTools.epsilonEqualsFloatSequence((IDLSequence.Float)msg.floatSeqTest_, (IDLSequence.Float)other.floatSeqTest_, (double)epsilon)) {
            errors.add(new AssertionError((Object)("floatSeqTest_: msg: " + String.valueOf(msg.floatSeqTest_) + " other:" + String.valueOf(other.floatSeqTest_))));
        }
        if (!IDLTools.epsilonEqualsDoubleSequence((IDLSequence.Double)msg.doubleSeqTest_, (IDLSequence.Double)other.doubleSeqTest_, (double)epsilon)) {
            errors.add(new AssertionError((Object)("doubleSeqTest_: msg: " + String.valueOf(msg.doubleSeqTest_) + " other:" + String.valueOf(other.doubleSeqTest_))));
        }
        if (!IDLTools.epsilonEqualsBooleanSequence((IDLSequence.Boolean)msg.booleanSeqTest_, (IDLSequence.Boolean)other.booleanSeqTest_, (double)epsilon)) {
            errors.add(new AssertionError((Object)("booleanSeqTest_: msg: " + String.valueOf(msg.booleanSeqTest_) + " other:" + String.valueOf(other.booleanSeqTest_))));
        }
        if (msg.nestedSeqTest_.size() != other.nestedSeqTest_.size()) {
            errors.add(new AssertionError((Object)("nestedSeqTest_.size(): msg: " + msg.nestedSeqTest_.size() + " other:" + other.nestedSeqTest_.size())));
        } else {
            for (int i = 0; i < msg.nestedSeqTest_.size(); ++i) {
                if (((NestedElement)((Object)msg.nestedSeqTest_.get(i))).epsilonEquals((NestedElement)((Object)other.nestedSeqTest_.get(i)), epsilon)) continue;
                errors.add(new AssertionError((Object)("nestedSeqTest_.get(i): msg: " + String.valueOf(msg.nestedSeqTest_.get(i)) + " other:" + String.valueOf(other.nestedSeqTest_.get(i)))));
            }
        }
        if (!IDLTools.epsilonEqualsEnumSequence(msg.enumSeqTest_, other.enumSeqTest_, (double)epsilon)) {
            errors.add(new AssertionError((Object)("enumSeqTest_: msg: " + String.valueOf(msg.enumSeqTest_) + " other:" + String.valueOf(other.enumSeqTest_))));
        }
        if (!IDLTools.epsilonEqualsStringBuilderSequence((IDLSequence.StringBuilderHolder)msg.stringSeqTest_, (IDLSequence.StringBuilderHolder)other.stringSeqTest_, (double)epsilon)) {
            errors.add(new AssertionError((Object)("stringSeqTest_: msg: " + String.valueOf(msg.stringSeqTest_) + " other:" + String.valueOf(other.stringSeqTest_))));
        }
        return errors;
    }
}

